/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.applet;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JToolBar;
import org.freeplane.core.ui.components.PersistentEditableComboBox;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.menu.JToolbarComponentBuilder;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;

class BToolbarContributor
implements EntryVisitor,
IMapViewChangeListener {
    private static final String BROWSE_URL_STORAGE_KEY = "browse_url_storage";
    private PersistentEditableComboBox urlfield = new PersistentEditableComboBox("browse_url_storage", 20);

    public BToolbarContributor() {
        this.urlfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String urlText = BToolbarContributor.this.urlfield.getText();
                if ("".equals(urlText) || e.getActionCommand().equals("comboBoxEdited")) {
                    return;
                }
                try {
                    Controller.getCurrentModeController().getMapController().openMap(new URL(urlText));
                }
                catch (Exception e1) {
                    LogUtils.warn(e1);
                }
            }
        });
    }

    @Override
    public void afterViewChange(Component oldView, Component newView) {
        if (newView == null) {
            return;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        mapViewManager.getModeController(newView);
        MapModel map = mapViewManager.getModel(newView);
        URL url = map.getURL();
        if (url == null) {
            return;
        }
        this.setURLField(url.toString());
    }

    private void setURLField(String text) {
        this.urlfield.setText(text);
    }

    @Override
    public void visit(Entry entry) {
        JToolBar container = (JToolBar)new EntryAccessor().getAncestorComponent(entry);
        GridBagConstraints constraints = JToolbarComponentBuilder.layoutConstraintsForEntry(entry, this.urlfield);
        container.add((Component)this.urlfield, constraints);
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return true;
    }
}

