/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.freeplane.features.map.MapController;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.FoldingMark;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;

abstract class MainViewPainter {
    private static final Rectangle EMPTY_RECTANGLE = new Rectangle();
    MainView mainView;

    MainViewPainter(MainView mainView) {
        this.mainView = mainView;
    }

    int getMainViewHeightWithFoldingMark(boolean onlyFolded) {
        int height = this.mainView.getHeight();
        NodeView nodeView = this.mainView.getNodeView();
        if (nodeView.usesHorizontalLayout() && (!onlyFolded || nodeView.isFolded())) {
            height += 2 * this.mainView.getZoomedFoldingMarkHalfWidth();
        }
        return height;
    }

    int getMainViewWidthWithFoldingMark(boolean onlyFolded) {
        int width = this.mainView.getWidth();
        NodeView nodeView = this.mainView.getNodeView();
        if (!(nodeView.usesHorizontalLayout() || onlyFolded && !nodeView.isFolded())) {
            width += this.mainView.getZoomedFoldingMarkHalfWidth() * 3;
        }
        return width;
    }

    int getSingleChildShift() {
        return 0;
    }

    Point getConnectorPoint(Point relativeLocation, MainView.ConnectorLocation connectorLocation) {
        return connectorLocation.pointSupplier.apply(this);
    }

    Point getCenterPoint() {
        return new Point(this.mainView.getWidth() / 2, this.mainView.getHeight() / 2);
    }

    abstract Point getLeftPoint();

    abstract Point getRightPoint();

    Point getTopPoint() {
        return new Point(this.mainView.getWidth() / 2, 0);
    }

    Point getBottomPoint() {
        return new Point(this.mainView.getWidth() / 2, this.mainView.getHeight());
    }

    abstract NodeGeometryModel getShapeConfiguration();

    abstract void paintBackground(Graphics2D var1, Color var2);

    void paintComponent(Graphics graphics) {
        this.mainView.paintComponentDefault(graphics);
    }

    void paintDecoration(NodeView nodeView, Graphics2D g) {
        boolean shouldPaintCloneMarker;
        this.mainView.drawModificationRect(g);
        this.mainView.paintDragRectangle(g);
        this.paintFoldingMark(nodeView, g);
        boolean isMinimized = this.mainView.isShortened();
        boolean bl = shouldPaintCloneMarker = nodeView.getModel().isCloneNode() && this.mainView.shouldPaintCloneMarker(nodeView);
        if (isMinimized) {
            FoldingMark.SHORTENED.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, shouldPaintCloneMarker ? 0.6 : 0.0, 2.3333333333333335, 1.6666666666666667));
        }
        if (shouldPaintCloneMarker) {
            if (nodeView.getModel().isCloneTreeRoot()) {
                FoldingMark.CLONE.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, isMinimized ? -0.6 : 0.0, 2.0, 2.5));
            } else if (nodeView.getModel().isCloneTreeNode()) {
                FoldingMark.CLONE.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, isMinimized ? -0.6 : 0.0, 1.5, 2.5));
            }
        }
    }

    void paintFoldingMark(NodeView nodeView, Graphics2D g) {
        boolean drawsControls;
        if (!this.mainView.hasChildren()) {
            return;
        }
        MapView map = this.mainView.getMap();
        MapController mapController = map.getModeController().getMapController();
        FoldingMark markType = this.mainView.foldingMarkType(mapController, nodeView);
        boolean bl = drawsControls = this.mainView.getMouseArea() != MouseArea.OUT && !map.isPrinting();
        if (markType == FoldingMark.FOLDING_CIRCLE_UNFOLDED && !drawsControls) {
            return;
        }
        Rectangle markBounds = this.getFoldingRectangleBounds(nodeView, drawsControls);
        (drawsControls || markType != FoldingMark.FOLDING_CIRCLE_FOLDED ? markType : FoldingMark.FOLDING_CIRCLE_UNFOLDED).draw(g, nodeView, markBounds);
    }

    Rectangle getFoldingRectangleBounds(NodeView nodeView, boolean drawsControls) {
        Point p;
        int width = drawsControls ? Math.max(this.mainView.getZoomedFoldingSwitchMinWidth(), this.mainView.getZoomedFoldingMarkHalfWidth() * 2) : this.mainView.getZoomedFoldingMarkHalfWidth() * 2;
        int halfWidth = width / 2;
        if (!drawsControls && !nodeView.isFolded()) {
            return EMPTY_RECTANGLE;
        }
        if (nodeView.usesHorizontalLayout()) {
            if (nodeView.isTopOrLeft()) {
                p = this.getTopPoint();
                p.y -= halfWidth;
            } else {
                p = this.getBottomPoint();
                p.y += halfWidth;
            }
        } else {
            Point point = p = this.mainView.getNodeView().paintsChildrenOnTheLeft() ? this.getLeftPoint() : this.getRightPoint();
            p.x = p.x <= 0 ? (p.x -= halfWidth) : (p.x += halfWidth);
        }
        Rectangle markBounds = new Rectangle(p.x - halfWidth, p.y - halfWidth, halfWidth * 2, halfWidth * 2);
        return markBounds;
    }

    boolean areInsetsFixed() {
        return true;
    }

    Insets getZoomedInsets() {
        return this.mainView.getDefaultZoomedInsets();
    }

    Insets getInsets() {
        return this.mainView.getDefaultInsets();
    }

    Insets getInsets(Insets insets) {
        return this.mainView.getDefaultInsets(insets);
    }

    Dimension getPreferredSize() {
        return this.mainView.getDefaultPreferredSize();
    }

    void setBounds(int x, int y, int width, int height) {
        this.mainView.setBoundsDefault(x, y, width, height);
    }
}

