/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.VariableInsetsPainter;

class NarrowHexagonPainter
extends VariableInsetsPainter {
    private static final double HORIZONTAL_MARGIN_FACTOR = 1.0;
    private static final double UNIFORM_HEIGHT_TO_WIDTH_RELATION = 2.0 / Math.sqrt(3.0);
    private static final double VERTICAL_MARGIN_FACTOR = 2.0;

    NarrowHexagonPainter(MainView mainView, NodeGeometryModel shapeConfigurationModel) {
        super(mainView, shapeConfigurationModel);
    }

    @Override
    double getVerticalMarginFactor() {
        return 2.0;
    }

    @Override
    double getHorizontalMarginFactor() {
        return 1.0;
    }

    @Override
    Dimension getPreferredSize() {
        if (this.mainView.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getShapeConfiguration().isUniform()) {
            Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.mainView.getMaximumWidth());
            double width = Math.ceil((double)prefSize.width + this.getMinimumHorizontalInset());
            width = this.mainView.limitWidth(width);
            prefSize.width = (int)width;
            prefSize.height = (int)(width * UNIFORM_HEIGHT_TO_WIDTH_RELATION);
            return prefSize;
        }
        return super.getPreferredSize();
    }

    @Override
    void paintNodeShape(Graphics2D g) {
        Polygon polygon = this.getPaintedShape();
        g.draw(polygon);
    }

    Polygon getPaintedShape() {
        double[] yCoords;
        double[] xCoords;
        if (this.getShapeConfiguration().isUniform()) {
            xCoords = new double[]{0.5, 0.0, 0.0, 0.5, 1.0, 1.0};
            yCoords = new double[]{0.0, 0.25, 0.75, 1.0, 0.75, 0.25};
        } else {
            double zoomedVerticalInset = (1.0 - 1.0 / this.getVerticalMarginFactor()) / 2.0;
            xCoords = new double[]{0.0, 0.5, 1.0, 1.0, 0.5, 0.0};
            yCoords = new double[]{zoomedVerticalInset, 0.0, zoomedVerticalInset, 1.0 - zoomedVerticalInset, 1.0, 1.0 - zoomedVerticalInset};
        }
        return this.polygonOf(xCoords, yCoords);
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fill(this.getPaintedShape());
    }
}

