/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.VariableInsetsPainter;

class OvalPainter
extends VariableInsetsPainter {
    private static final double MARGIN_FACTOR = Math.sqrt(2.0);

    OvalPainter(MainView mainView, NodeGeometryModel shapeConfigurationModel) {
        super(mainView, shapeConfigurationModel);
    }

    @Override
    double getVerticalMarginFactor() {
        return MARGIN_FACTOR;
    }

    @Override
    double getHorizontalMarginFactor() {
        return MARGIN_FACTOR;
    }

    @Override
    void paintNodeShape(Graphics2D g) {
        int zoomedEdgeWidth = (int)this.mainView.getPaintedBorderWidth();
        g.drawOval(zoomedEdgeWidth / 2, zoomedEdgeWidth / 2, this.mainView.getWidth() - zoomedEdgeWidth, this.mainView.getHeight() - zoomedEdgeWidth);
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillOval(1, 1, this.mainView.getWidth() - 2, this.mainView.getHeight() - 2);
    }

    @Override
    Point getConnectorPoint(Point relativeLocation, MainView.ConnectorLocation connectorLocation) {
        return this.getShapeConfiguration().isUniform() || !MainView.USE_COMMON_OUT_POINT_FOR_ROOT_NODE && this.mainView.getNodeView().isRoot() ? this.getConnectorPointAtTheOvalBorder(relativeLocation) : super.getConnectorPoint(relativeLocation, connectorLocation);
    }

    @Override
    Dimension getPreferredSize() {
        if (this.mainView.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getShapeConfiguration().isUniform()) {
            Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.mainView.getMaximumWidth());
            double w = (double)prefSize.width + this.getMinimumHorizontalInset();
            double h = (double)prefSize.height + this.getMinimumVerticalInset();
            int diameter = (int)Math.ceil(Math.sqrt(w * w + h * h));
            prefSize.width = prefSize.height = this.mainView.limitWidth(diameter);
            return prefSize;
        }
        return super.getPreferredSize();
    }

    private Point getConnectorPointAtTheOvalBorder(Point p) {
        double angle;
        double nWidth = (float)this.mainView.getWidth() / 2.0f;
        double nHeight = (float)this.mainView.getHeight() / 2.0f;
        int dx = Math.abs(p.x - this.mainView.getWidth() / 2);
        if (p.x < this.mainView.getWidth() / 2) {
            dx = -dx;
        }
        double d = dx != 0 ? Math.atan(((double)p.y - nHeight) / (double)dx) : (angle = ((double)p.y > nHeight ? Math.PI : -Math.PI) / 2.0);
        if (dx < 0) {
            angle += Math.PI;
        }
        Point out = new Point((int)((1.0 + Math.cos(angle)) * nWidth), (int)((1.0 + Math.sin(angle)) * nHeight));
        return out;
    }
}

