/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.attribute.AttributeTable;
import org.freeplane.view.swing.map.attribute.AttributeTableModel;

class AttributeTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    static final float ZOOM_CORRECTION_FACTOR = 0.97f;
    private boolean isPainting;
    private float zoom;
    private boolean opaque;

    @Override
    public int getHeight() {
        if (this.isPainting && this.zoom != 1.0f) {
            return (int)((float)super.getHeight() / this.zoom);
        }
        return super.getHeight();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ViewerController viewerController;
        Icon scaledIcon;
        Icon icon;
        String originalText;
        Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        AttributeTable attributeTable = (AttributeTable)table;
        this.zoom = attributeTable.getZoom();
        AttributeTableModel attributeTableModel = (AttributeTableModel)table.getModel();
        String text = originalText = value == null ? null : value.toString();
        Color color = null;
        Hyperlink link = null;
        if (column == 1 && this.isAttributeHighlighted(attributeTable, row)) {
            color = FilterController.HIGHLIGHT_COLOR;
        }
        if (column == 1 && value != null) {
            try {
                TextController textController = TextController.getController();
                Object transformedObject = textController.getTransformedObject(attributeTableModel.getNode(), attributeTableModel.getNodeAttributeModel(), value);
                text = transformedObject.toString();
                if (color == null && transformedObject instanceof HighlightedTransformedObject && TextController.isMarkTransformedTextSet()) {
                    color = HighlightedTransformedObject.OK_COLOR;
                }
            }
            catch (Exception e) {
                text = TextUtils.format("MainView.errorUpdateText", originalText, e.getLocalizedMessage());
                color = HighlightedTransformedObject.FAILURE_COLOR;
            }
            link = attributeTable.toHyperlink(value);
            icon = link != null ? attributeTable.getLinkIcon(link) : null;
        } else {
            icon = null;
        }
        this.configureBorder(color);
        IconFactory iconFactory = IconFactory.getInstance();
        if (icon != null && iconFactory.canScaleIcon(icon)) {
            int fontSize = this.getFont().getSize();
            scaledIcon = iconFactory.getScaledIcon(icon, (Quantity<LengthUnit>)new Quantity((double)fontSize, (Enum)LengthUnit.px));
        } else {
            scaledIcon = icon;
        }
        if (scaledIcon != this.getIcon()) {
            this.setIcon(scaledIcon);
        }
        this.setText(text);
        String toolTip = null;
        if (link != null && (viewerController = Controller.getCurrentModeController().getExtension(ViewerController.class)) != null && viewerController.getViewerFactory().accept(link.getUri())) {
            toolTip = link.toString();
        }
        if (toolTip == null) {
            if (text != originalText) {
                toolTip = HtmlUtils.plainToHTML(originalText);
            } else {
                int prefWidth = this.getPreferredSize().width;
                int width = table.getColumnModel().getColumn(column).getWidth();
                if (prefWidth > width) {
                    toolTip = HtmlUtils.plainToHTML(text);
                }
            }
        }
        this.setToolTipText(toolTip);
        this.setOpaque(isSelected);
        return rendererComponent;
    }

    private boolean isAttributeHighlighted(AttributeTable attributeTable, int row) {
        NodeAttributeTableModel attributes = attributeTable.getAttributeTableModel().getNodeAttributeModel();
        if (attributes.getRowCount() <= row) {
            return false;
        }
        Attribute attribute = attributes.getAttribute(row);
        return MapView.isElementHighlighted(attributeTable, attribute);
    }

    private void configureBorder(Color color) {
        if (color != null) {
            this.setBorder(BorderFactory.createLineBorder(color));
        }
    }

    @Override
    public int getWidth() {
        if (this.isPainting && this.zoom != 1.0f) {
            return (int)(0.99f + (float)super.getWidth() / this.zoom);
        }
        return super.getWidth();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.zoom != 1.0f) {
            this.zoom *= 0.97f;
            AffineTransform transform = g2.getTransform();
            g2.scale(this.zoom, this.zoom);
            this.isPainting = true;
            super.paint(g);
            this.isPainting = false;
            g2.setTransform(transform);
        } else {
            super.paint(g);
        }
    }

    @Override
    public boolean isOpaque() {
        return this.opaque;
    }

    @Override
    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }
}

