/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributePopupMenu;
import org.freeplane.view.swing.map.attribute.AttributeTable;
import org.freeplane.view.swing.map.attribute.AttributeTableModel;
import org.freeplane.view.swing.map.attribute.AttributeViewScrollPane;
import org.freeplane.view.swing.map.attribute.ExtendedAttributeTableModelDecorator;
import org.freeplane.view.swing.map.attribute.ReducedAttributeTableModelDecorator;

public class AttributeView
implements ChangeListener,
TableModelListener {
    private static final Color HEADER_BACKGROUND = UIManager.getColor("TableHeader.background");
    private static AttributePopupMenu tablePopupMenu;
    private AttributeTable attributeTable;
    private JComponent attributeTableContainer;
    private AttributeTableModel currentAttributeTableModel;
    private ExtendedAttributeTableModelDecorator extendedAttributeTableModel = null;
    private final NodeView nodeView;
    private final ReducedAttributeTableModelDecorator reducedAttributeTableModel;
    private JTableHeader tableHeader;
    private ListSelectionListener tableSelectionListener;
    private boolean belongsToNodeView;
    private static int VIEWER_POSITION;

    public AttributeView(NodeView nodeView, boolean addToNodeView) {
        this.nodeView = nodeView;
        this.belongsToNodeView = addToNodeView;
        if (addToNodeView) {
            this.reducedAttributeTableModel = new ReducedAttributeTableModelDecorator(this);
            this.currentAttributeTableModel = this.reducedAttributeTableModel;
        } else {
            this.reducedAttributeTableModel = null;
            this.extendedAttributeTableModel = new ExtendedAttributeTableModelDecorator(this);
            this.currentAttributeTableModel = this.extendedAttributeTableModel;
        }
        this.setViewType(this.getAttributeRegistry().getAttributeViewType());
        this.addListeners();
    }

    private void addListeners() {
        this.getAttributeRegistry().addChangeListener(this);
        this.addTableListeners();
    }

    private void addTableListeners() {
        if (!this.getMapView().getModeController().canEdit()) {
            return;
        }
        if (this.attributeTable != null) {
            if (tablePopupMenu == null) {
                tablePopupMenu = new AttributePopupMenu();
            }
            this.getAttributes().getLayout().addColumnWidthChangeListener(this.attributeTable);
            this.attributeTable.addMouseListener(tablePopupMenu);
            this.tableHeader.addMouseListener(tablePopupMenu);
            if (this.tableSelectionListener != null) {
                this.attributeTable.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
                this.attributeTable.getColumnModel().getSelectionModel().addListSelectionListener(this.tableSelectionListener);
            }
        } else {
            this.getAttributes().addTableModelListener(this);
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public boolean areAttributesVisible() {
        String viewType = this.getViewType();
        return viewType != "hide" && (this.currentAttributeTableModel.areAttributesVisible() || viewType != this.getAttributeRegistry().getAttributeViewType());
    }

    AttributeRegistry getAttributeRegistry() {
        return AttributeRegistry.getRegistry(this.getNode().getMap());
    }

    public NodeAttributeTableModel getAttributes() {
        return NodeAttributeTableModel.getModel(this.getNode());
    }

    public TableModel getCurrentAttributeTableModel() {
        return this.currentAttributeTableModel;
    }

    private ExtendedAttributeTableModelDecorator getExtendedAttributeTableModel() {
        if (this.extendedAttributeTableModel == null) {
            this.extendedAttributeTableModel = new ExtendedAttributeTableModelDecorator(this);
        }
        return this.extendedAttributeTableModel;
    }

    public MapView getMapView() {
        return this.getNodeView().getMap();
    }

    NodeModel getNode() {
        return this.getNodeView().getModel();
    }

    public NodeView getNodeView() {
        return this.nodeView;
    }

    public String getViewType() {
        return this.currentAttributeTableModel == this.reducedAttributeTableModel ? this.getAttributeRegistry().getAttributeViewType() : "extended";
    }

    boolean isPopupShown() {
        return this.attributeTable != null && tablePopupMenu != null && tablePopupMenu.getTable() == this.attributeTable;
    }

    private void provideAttributeTable() {
        if (this.attributeTable == null) {
            this.getAttributes().removeTableModelListener(this);
            this.attributeTable = new AttributeTable(this);
            this.tableHeader = this.attributeTable.getTableHeader();
            this.tableHeader.setBackground(HEADER_BACKGROUND);
            this.addTableListeners();
            if (this.belongsToNodeView) {
                this.attributeTableContainer = new AttributeViewScrollPane(this.attributeTable);
            } else {
                this.attributeTableContainer = Box.createVerticalBox();
                this.attributeTableContainer.add((Component)this.attributeTable.getTableHeader(), 0);
                this.attributeTableContainer.add((Component)this.attributeTable, 1);
                Border border = BorderFactory.createLineBorder(this.attributeTable.getGridColor());
                this.attributeTableContainer.setBorder(border);
            }
            this.attributeTableContainer.setAlignmentX(0.0f);
            if (this.isReduced()) {
                this.getNodeView().addContent(this.attributeTableContainer, VIEWER_POSITION);
            }
            this.setViewType(this.getAttributeRegistry().getAttributeViewType());
        }
    }

    boolean isReduced() {
        return this.reducedAttributeTableModel != null;
    }

    private void removeListeners() {
        this.getAttributeRegistry().removeChangeListener(this);
        if (!this.getMapView().getModeController().canEdit()) {
            return;
        }
        if (this.attributeTable != null) {
            this.getAttributes().getLayout().removeColumnWidthChangeListener(this.attributeTable);
            this.attributeTable.getModel().removeTableModelListener(this.attributeTable);
            this.attributeTable.removeMouseListener(tablePopupMenu);
            this.tableHeader.removeMouseListener(tablePopupMenu);
            tablePopupMenu = null;
        } else {
            this.getAttributes().removeTableModelListener(this);
        }
    }

    private void setViewType(String viewType) {
        JTableHeader currentColumnHeaderView = null;
        if (viewType == "extended" || !this.isReduced()) {
            this.currentAttributeTableModel = this.getExtendedAttributeTableModel();
            currentColumnHeaderView = this.tableHeader;
        } else {
            this.currentAttributeTableModel = this.reducedAttributeTableModel;
        }
        if (this.attributeTable != null) {
            this.attributeTable.setModel(this.currentAttributeTableModel);
            this.attributeTable.setTableHeader(currentColumnHeaderView);
            if (this.belongsToNodeView) {
                ((JScrollPane)this.attributeTableContainer).setColumnHeaderView(currentColumnHeaderView);
            } else {
                this.attributeTableContainer.remove(0);
                this.attributeTableContainer.add(this.attributeTable.getTableHeader(), "First", 0);
            }
            this.attributeTableContainer.invalidate();
        }
    }

    public void startEditing() {
        this.provideAttributeTable();
        if (this.currentAttributeTableModel == this.reducedAttributeTableModel) {
            this.getExtendedAttributeTableModel();
            this.setViewType("extended");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttributeView.this.startEditingTable();
            }
        });
    }

    private void startEditingTable() {
        this.attributeTable.requestFocusInWindow();
        if (this.currentAttributeTableModel.getRowCount() == 0) {
            this.attributeTable.insertRow(0);
        } else {
            this.attributeTable.changeSelection(0, 0, false, false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.setViewType(this.getAttributeRegistry().getAttributeViewType());
        if (this.isReduced()) {
            this.reducedAttributeTableModel.stateChanged(null);
        }
        if (this.attributeTable != null) {
            this.attributeTable.revalidate();
        }
    }

    public void stopEditing() {
        String registryAttributeViewType;
        if (this.attributeTable.isEditing()) {
            this.attributeTable.getCellEditor().stopCellEditing();
        }
        if ((registryAttributeViewType = this.getAttributeRegistry().getAttributeViewType()) != this.getViewType()) {
            this.setViewType(registryAttributeViewType);
        }
        this.getNodeView().requestFocusInWindow();
    }

    public void syncronizeAttributeView() {
        if (this.attributeTable == null && this.currentAttributeTableModel.areAttributesVisible()) {
            this.provideAttributeTable();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        NodeModel node = this.getNode();
        this.getMapView().getModeController().getMapController().nodeChanged(node);
    }

    public void update() {
        if (this.attributeTable != null && this.attributeTable.isVisible()) {
            this.attributeTable.updateAttributeTable();
        }
    }

    public void viewRemoved() {
        this.removeListeners();
        if (this.isReduced()) {
            this.reducedAttributeTableModel.viewRemoved(this.nodeView);
        }
        if (this.extendedAttributeTableModel != null) {
            this.extendedAttributeTableModel.viewRemoved(this.nodeView);
        }
        if (this.attributeTable != null) {
            this.attributeTable.viewRemoved(this.nodeView);
            this.attributeTable = null;
        }
    }

    JComponent getContainer() {
        if (this.attributeTableContainer == null) {
            this.provideAttributeTable();
        }
        return this.attributeTableContainer;
    }

    public void addRow() {
        this.attributeTable.insertRow(this.attributeTable.getRowCount());
    }

    public void setOptimalColumnWidths() {
        this.syncronizeAttributeView();
        if (this.attributeTable != null) {
            this.attributeTable.setOptimalColumnWidths();
        }
    }

    public AttributeTable getAttributeTable() {
        return this.attributeTable;
    }

    public void addTableSelectionListener(ListSelectionListener listSelectionListener) {
        this.tableSelectionListener = listSelectionListener;
    }

    static {
        VIEWER_POSITION = 3;
    }
}

