/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.edge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class AutomaticEdgeStyle {
    private Color color;

    public AutomaticEdgeStyle(NodeView node) {
        EdgeController edgeController;
        int nodeColumnWidth;
        int distance;
        MapView map = node.getMap();
        ModeController modeController = map.getModeController();
        modeController.getExtension(NodeStyleController.class);
        NodeView rootView = map.getRoot();
        Point origin = new Point();
        MainView rootContent = rootView.getMainView();
        UITools.convertPointToAncestor((Component)rootContent, origin, rootView);
        Point coordinate = new Point();
        MainView nodeContent = node.getMainView();
        UITools.convertPointToAncestor((Component)nodeContent, coordinate, rootView);
        MapStyleModel mapStyleNodes = MapStyleModel.getExtension(map.getModel());
        if (map.getLayoutType() == MapViewLayout.OUTLINE) {
            distance = Math.max(0, coordinate.x - origin.x);
            int hgapProperty = ResourceController.getResourceController().getLengthProperty("outline_hgap");
            nodeColumnWidth = Math.max(1, map.getZoomed(hgapProperty));
        } else {
            distance = origin.x < coordinate.x ? Math.max(0, coordinate.x - origin.x + nodeContent.getWidth() - rootContent.getWidth()) : origin.x - coordinate.x;
            NodeModel defaultStyleNode = mapStyleNodes.getDefaultStyleNode();
            NodeStyleController nodeStyleController = modeController.getExtension(NodeStyleController.class);
            nodeColumnWidth = map.getZoomed(nodeStyleController.getMaxWidth(defaultStyleNode, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE).toBaseUnitsRounded() + LocationModel.DEFAULT_HGAP_PX);
        }
        int level = (int)((double)((float)distance / (float)nodeColumnWidth) + 0.5);
        if (SummaryNode.isHidden(node.getModel())) {
            ++level;
        }
        this.color = (edgeController = modeController.getExtension(EdgeController.class)).areEdgeColorsAvailable(map.getModel()) ? edgeController.getEdgeColor(map.getModel(), level) : EdgeController.STANDARD_EDGE_COLOR;
    }

    public Color getColor() {
        return this.color;
    }
}

