# Atari Lynx instrument editor

Atari Lynx instrument editor consists of these macros:

- **Volume**: volume sequence
- **Arpeggio**: pitch in half-steps
- **Duty/Int**: bit pattern for LFSR taps and integration
- **Panning (left)**: output level for left channel
- **Panning (right)**: output level for right channel
- **Pitch**: fine pitch
- **Phase Reset**: trigger restart of waveform

## Audio generation description

Atari Lynx generates sound using a 12-bit linear feedback shift register with configurable tap. Nine separate bits can be enabled to be the source of feedback: 0, 1, 2, 3, 4, 5, 7, 10 and 11. To generate _any_ sound at least one bit _must_ be enabled.

### Square wave

The LFSR is shifted at the rate define by sound pitch and generates square wave by setting channel output value to +volume or -volume, depending on the bit shifted in.

### Triangle wave

Alternatively when "int" bit is set sound wave is generated by adding or subtracting volume from output effectively producing triangle wave.

#### How triangle wave works?

Hint: To obtain triangle set bits "int" and "11" in "Duty/Int" sequence and set volume to about 22.
By enabling 11th tap bit the value shifted in is negated after 11 bit is shifted in hence the volume is added for 11 cycles and then subtracted for 11 cycles.
