/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class ComponentPanel
extends JPanel {
    private int myWidth;
    private int myHeight;
    private List<JComponent> myComponents;

    ComponentPanel(List<JComponent> components) {
        this.myComponents = this.sort(components);
        this.myHeight = 0;
        this.myWidth = 0;
        for (int i = 0; i < this.myComponents.size(); ++i) {
            JComponent component = this.myComponents.get(i);
            int width = this.getWidth(component);
            int height = this.getHeight(component);
            this.myWidth += width;
            if (height <= this.myHeight) continue;
            this.myHeight = height;
        }
    }

    @Override
    public void print(Graphics g) {
        for (JComponent component : this.myComponents) {
            component.print(g);
            g.translate(this.getWidth(component), 0);
        }
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    private int getWidth(JComponent component) {
        Dimension size = this.getSize(component);
        if (size == null) {
            return component.getWidth();
        }
        return size.width;
    }

    private int getHeight(JComponent component) {
        Dimension size = this.getSize(component);
        if (size == null) {
            return component.getHeight();
        }
        return size.height;
    }

    private Dimension getSize(JComponent component) {
        Object object = component.getClientProperty("print.size");
        if (object instanceof Dimension) {
            return (Dimension)object;
        }
        return null;
    }

    private List<JComponent> sort(List<JComponent> components) {
        Collections.sort(components, new Comparator<JComponent>(){

            @Override
            public int compare(JComponent component1, JComponent component2) {
                int order2;
                int order1 = this.getInteger(component1);
                if (order1 < (order2 = this.getInteger(component2).intValue())) {
                    return -1;
                }
                if (order1 == order2) {
                    return 0;
                }
                return 1;
            }

            private Integer getInteger(JComponent component) {
                Object object = component.getClientProperty("print.order");
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                return Integer.MIN_VALUE;
            }
        });
        return components;
    }
}

