/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Logger;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class ProjectOpenFilesHandler
implements OpenFilesHandler {
    private static final String GEPHI_EXTENSION = "gephi";

    @Override
    public void openFiles(OpenFilesEvent openFilesEvent) {
        WindowManager.getDefault().invokeWhenUIReady(() -> new Thread(() -> {
            Logger.getLogger(ProjectOpenFilesHandler.class.getName()).info("Handling " + openFilesEvent.getFiles().size() + " from opening");
            FileObject[] fileObjects = (FileObject[])openFilesEvent.getFiles().stream().filter(File::exists).map(FileUtil::toFileObject).toArray(FileObject[]::new);
            Optional<FileObject> projectFile = Arrays.stream(fileObjects).filter(f -> f.hasExt(GEPHI_EXTENSION)).findFirst();
            if (projectFile.isPresent()) {
                Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.OpenFile").actionPerformed(new ActionEvent(FileUtil.toFile((FileObject)projectFile.get()), 0, null));
            } else if (fileObjects.length > 0) {
                ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                importController.importFiles(fileObjects);
            }
        }, "ProjectOpenFilesHandler").start());
    }
}

