#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 glirc
version:              2.39.0.1
visibility:           public
id:                   glirc-2.39.0.1-5DX1uB4HBDACmQqmcBxaP5
key:                  glirc-2.39.0.1-5DX1uB4HBDACmQqmcBxaP5
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  eb0d3e9b3e216da6ef6f0adce968dfec
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Window
    Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.Digraphs Client.View.Help
    Client.View.IgnoreList Client.View.KeyMap Client.View.MaskList
    Client.View.Mentions Client.View.Messages Client.View.Palette
    Client.View.RtsStats Client.View.UrlSelection Client.View.UserList
    Client.View.Windows

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.0.2/site-local/glirc-2.39.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/glirc-2.39.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.39.0.1-5DX1uB4HBDACmQqmcBxaP5
include-dirs:         /usr/lib/ghc-9.0.2/site-local/glirc-2.39.0.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.6-DeQqb9zWlUPKmnwMCuOyfe
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En
    bytestring-0.10.12.1 config-schema-1.3.0.0-IBm17SAWYki6L3n665QM9M
    config-value-0.8.3-3pmzeYU8Vb25WTAZFoPyxS containers-0.6.4.1
    curve25519-0.2.7-I4NMRvj5vmk65awGhXSnnF directory-1.3.6.2
    filepath-1.4.2.1 free-5.1.10-JIdA28qKKvuIGxHjXb7ZXe
    githash-0.1.6.3-4OenuBfB1jl1qiRF0GwaeC
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    hookup-0.7-AULSBjo9E6A2cgmzOdm2VR
    irc-core-2.11-7IRWEjRUfhJFajIYT9qpr8
    kan-extensions-5.2.5-12K3DFSEkkRCSlgJd7xxJe
    lens-5.2.2-4uj1AepANiF2ook39zjsmk
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq process-1.6.13.2
    psqueues-0.2.7.3-AfhmY4zXhLw1txyXh9MWSt
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    regex-tdfa-1.3.2.2-9R5AJXd71FKmHTeEzzCL9
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf stm-2.5.0.0
    template-haskell-2.17.0.0 text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    vty-5.38-6guis7PXnUmAFxRihYvW2q

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

