// Code generated by "./generator ./com.deepin.daemon.authenticate.ukey"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package ukey

import "errors"
import "fmt"
import "github.com/godbus/dbus"

import "github.com/linuxdeepin/go-lib/dbusutil"
import "github.com/linuxdeepin/go-lib/dbusutil/proxy"
import "unsafe"

type UKey interface {
	ukey // interface com.deepin.daemon.Authenticate.UKey.Device
	proxy.Object
}

type objectUKey struct {
	interfaceUkey // interface com.deepin.daemon.Authenticate.UKey.Device
	proxy.ImplObject
}

func NewUKey(conn *dbus.Conn, serviceName string, path dbus.ObjectPath) (UKey, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectUKey)
	obj.ImplObject.Init_(conn, serviceName, path)
	return obj, nil
}

type ukey interface {
	SetInterfaceName_(name string)
	GoGetPINLength(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call
	GetPINLength(flags dbus.Flags, uuid string) (int32, error)
	GoGetUserList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	GetUserList(flags dbus.Flags) ([]string, error)
	GoSetPin(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string, pin string) *dbus.Call
	SetPin(flags dbus.Flags, uuid string, gid string, pin string) error
	GoSetSessionPath(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string, path string) *dbus.Call
	SetSessionPath(flags dbus.Flags, uuid string, gid string, path string) error
	GoStopVerify(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string) *dbus.Call
	StopVerify(flags dbus.Flags, uuid string, gid string) error
	GoVerify(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string) *dbus.Call
	Verify(flags dbus.Flags, uuid string, gid string) error
	ConnectVerifyResult(cb func(id string, msg string)) (dbusutil.SignalHandlerId, error)
	Name() proxy.PropString
	State() proxy.PropInt32
	Type() proxy.PropInt32
	Capability() proxy.PropInt32
}

type interfaceUkey struct{}

func (v *interfaceUkey) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (v *interfaceUkey) SetInterfaceName_(name string) {
	v.GetObject_().SetExtra("customIfc", name)
}

func (v *interfaceUkey) GetInterfaceName_() string {
	ifcName, _ := v.GetObject_().GetExtra("customIfc")
	ifcNameStr, _ := ifcName.(string)
	return ifcNameStr
}

// method GetPINLength

func (v *interfaceUkey) GoGetPINLength(flags dbus.Flags, ch chan *dbus.Call, uuid string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetPINLength", flags, ch, uuid)
}

func (*interfaceUkey) StoreGetPINLength(call *dbus.Call) (length int32, err error) {
	err = call.Store(&length)
	return
}

func (v *interfaceUkey) GetPINLength(flags dbus.Flags, uuid string) (int32, error) {
	return v.StoreGetPINLength(
		<-v.GoGetPINLength(flags, make(chan *dbus.Call, 1), uuid).Done)
}

// method GetUserList

func (v *interfaceUkey) GoGetUserList(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUserList", flags, ch)
}

func (*interfaceUkey) StoreGetUserList(call *dbus.Call) (users []string, err error) {
	err = call.Store(&users)
	return
}

func (v *interfaceUkey) GetUserList(flags dbus.Flags) ([]string, error) {
	return v.StoreGetUserList(
		<-v.GoGetUserList(flags, make(chan *dbus.Call, 1)).Done)
}

// method SetPin

func (v *interfaceUkey) GoSetPin(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string, pin string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetPin", flags, ch, uuid, gid, pin)
}

func (v *interfaceUkey) SetPin(flags dbus.Flags, uuid string, gid string, pin string) error {
	return (<-v.GoSetPin(flags, make(chan *dbus.Call, 1), uuid, gid, pin).Done).Err
}

// method SetSessionPath

func (v *interfaceUkey) GoSetSessionPath(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string, path string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetSessionPath", flags, ch, uuid, gid, path)
}

func (v *interfaceUkey) SetSessionPath(flags dbus.Flags, uuid string, gid string, path string) error {
	return (<-v.GoSetSessionPath(flags, make(chan *dbus.Call, 1), uuid, gid, path).Done).Err
}

// method StopVerify

func (v *interfaceUkey) GoStopVerify(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".StopVerify", flags, ch, uuid, gid)
}

func (v *interfaceUkey) StopVerify(flags dbus.Flags, uuid string, gid string) error {
	return (<-v.GoStopVerify(flags, make(chan *dbus.Call, 1), uuid, gid).Done).Err
}

// method Verify

func (v *interfaceUkey) GoVerify(flags dbus.Flags, ch chan *dbus.Call, uuid string, gid string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Verify", flags, ch, uuid, gid)
}

func (v *interfaceUkey) Verify(flags dbus.Flags, uuid string, gid string) error {
	return (<-v.GoVerify(flags, make(chan *dbus.Call, 1), uuid, gid).Done).Err
}

// signal VerifyResult

func (v *interfaceUkey) ConnectVerifyResult(cb func(id string, msg string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "VerifyResult", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".VerifyResult",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var id string
		var msg string
		err := dbus.Store(sig.Body, &id, &msg)
		if err == nil {
			cb(id, msg)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Name s

func (v *interfaceUkey) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property State i

func (v *interfaceUkey) State() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "State",
	}
}

// property Type i

func (v *interfaceUkey) Type() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "Type",
	}
}

// property Capability i

func (v *interfaceUkey) Capability() proxy.PropInt32 {
	return &proxy.ImplPropInt32{
		Impl: v,
		Name: "Capability",
	}
}
