/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import org.gradle.api.internal.artifacts.transform.TransformWorkspaceIdentity;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.ValueSnapshot;

class MutableTransformWorkspaceIdentity
implements TransformWorkspaceIdentity {
    private final String inputArtifactAbsolutePath;
    private final String producerBuildTreePath;
    private final ValueSnapshot secondaryInputsSnapshot;
    private final HashCode dependenciesHash;

    public MutableTransformWorkspaceIdentity(String inputArtifactAbsolutePath, String producerBuildTreePath, ValueSnapshot secondaryInputsSnapshot, HashCode dependenciesHash) {
        this.inputArtifactAbsolutePath = inputArtifactAbsolutePath;
        this.producerBuildTreePath = producerBuildTreePath;
        this.secondaryInputsSnapshot = secondaryInputsSnapshot;
        this.dependenciesHash = dependenciesHash;
    }

    public String getUniqueId() {
        Hasher hasher = Hashing.newHasher();
        hasher.putString((CharSequence)this.inputArtifactAbsolutePath);
        hasher.putString((CharSequence)this.producerBuildTreePath);
        this.secondaryInputsSnapshot.appendToHasher(hasher);
        hasher.putHash(this.dependenciesHash);
        return hasher.hash().toString();
    }

    @Override
    public ValueSnapshot getSecondaryInputsSnapshot() {
        return this.secondaryInputsSnapshot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableTransformWorkspaceIdentity that = (MutableTransformWorkspaceIdentity)o;
        if (!this.secondaryInputsSnapshot.equals(that.secondaryInputsSnapshot)) {
            return false;
        }
        if (!this.dependenciesHash.equals((Object)that.dependenciesHash)) {
            return false;
        }
        if (!this.producerBuildTreePath.equals(that.producerBuildTreePath)) {
            return false;
        }
        return this.inputArtifactAbsolutePath.equals(that.inputArtifactAbsolutePath);
    }

    public int hashCode() {
        int result = this.inputArtifactAbsolutePath.hashCode();
        result = 31 * result + this.secondaryInputsSnapshot.hashCode();
        result = 31 * result + this.dependenciesHash.hashCode();
        return result;
    }
}

