#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
key:                  aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  ec2b60d1ba97e6debeb07591a83a6528
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.0.2/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
depends:
    OneTuple-0.3.1-7kNi6qPOaQ0s3dVWFtb4J
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base-compat-batteries-0.12.2-AT4hp2TNkcP3aSTeYrld5l
    bytestring-0.10.12.1 containers-0.6.4.1
    data-fix-0.3.2-F5YI9qAj3M1GeOditmsT5l deepseq-1.4.5.0
    dlist-1.0-JalAZsGq1LOCqqdFHHEpoL exceptions-0.10.4
    generically-0.1.1-GClPV9eoCfuGbJLVBKfJF3 ghc-prim-0.7.0
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    indexed-traversable-0.1.2.1-JwIQVWOpW67GVSWDdLo884
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR
    semialign-1.2.0.1-L3HiqIPbIDwG6hqCRiIHhY
    strict-0.4.0.1-DqIvrYJvHoWHqER1V0TQ0H
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf template-haskell-2.17.0.0
    text-1.2.5.0 text-short-0.1.5-CLLiD2mlatGBfIv4YcXASu
    th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp
    these-1.1.1.1-Co8qfzI8wtgJaT0RN5FqXo time-1.9.3
    time-compat-1.9.6.1-JOYXP7yfHEj1VTYE9SgZqI
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    uuid-types-1.0.5-7u50b6xgE4NKbeFi1oGinA
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    witherable-0.4.2-2NuA17KbjD52ji6DYytJEq

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

