#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 bin
version:              0.1.3
visibility:           public
id:                   bin-0.1.3-J1q6ijwBHnd7TKhJha3Uw8
key:                  bin-0.1.3-J1q6ijwBHnd7TKhJha3Uw8
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  6b95852a13c5c9542c500dfbaf28afd7
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.0.2/site-local/bin-0.1.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/bin-0.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bin
hs-libraries:         HSbin-0.1.3-J1q6ijwBHnd7TKhJha3Uw8
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4 base-4.15.1.0
    boring-0.2.1-A8wgoiDmgwXAhCQHRXaSX4
    dec-0.0.5-EMy4RqsyQ6VJ3jWA1xpkJp deepseq-1.4.5.0
    fin-0.3-InZwebmfZLj78okgHGpyyr
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    some-1.0.5-2CCxSGFRQ8m3FjAx9nXmXm

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

