#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 brick
version:              0.71.1
visibility:           public
id:                   brick-0.71.1-22NNNcwQmRh7NNyhJmmxU9
key:                  brick-0.71.1-22NNNcwQmRh7NNyhJmmxU9
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  bcb52fa8b5d83a4b564aa5c24786b0be
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Main Brick.Themes Brick.Types Brick.Util
    Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.Internal
    Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.0.2/site-local/brick-0.71.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/brick-0.71.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick0.71
hs-libraries:         HSbrick-0.71.1-22NNNcwQmRh7NNyhJmmxU9
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    config-ini-0.2.6.0-HwIr3Hat6UE1ZIzzFrkDBs containers-0.6.4.1
    contravariant-1.5.5-FtJyCLyWfutGN2UWoJs8qd
    data-clist-0.2-4kkuO7OFN9tGIif7Mquj2e deepseq-1.4.5.0
    directory-1.3.6.2 dlist-1.0-JalAZsGq1LOCqqdFHHEpoL
    exceptions-0.10.4 filepath-1.4.2.1
    microlens-0.4.13.1-AoR6D5midYZB5ErWoiySs4
    microlens-mtl-0.2.0.3-1bQnOxrDGVaBhXPSWw1eDJ
    microlens-th-0.4.3.13-2F8uJinYM5B66CBFDh33gA stm-2.5.0.0
    template-haskell-2.17.0.0 text-1.2.5.0
    text-zipper-0.13-9XVMCbsNtDxGZAOYWi2DXX transformers-0.5.6.2
    unix-2.7.2.2 vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    vty-5.38-6guis7PXnUmAFxRihYvW2q
    word-wrap-0.5-AyS7XGDzT716BRnnkngtJ9

haddock-interfaces:   /usr/share/doc/haskell-brick0.71/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick0.71/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

