#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 chimera
version:              0.3.3.0
visibility:           public
id:                   chimera-0.3.3.0-16v0QWF5AX4b1LEwipnyT
key:                  chimera-0.3.3.0-16v0QWF5AX4b1LEwipnyT
license:              BSD-3-Clause
copyright:            2017-2019 Bodigrim
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/chimera#readme
synopsis:
    Lazy infinite streams with O(1) indexing and applications for memoization

description:
    There are plenty of memoizing libraries on Hackage, but they
    usually fall into two categories:

    * Store cache as a flat array, enabling us
    to obtain cached values in O(1) time, which is nice.
    The drawback is that one must specify the size
    of the array beforehand,
    limiting an interval of inputs,
    and actually allocate it at once.
    * Store cache as a lazy binary tree.
    Thanks to laziness, one can freely use the full range of inputs.
    The drawback is that obtaining values from a tree
    takes logarithmic time and is unfriendly to CPU cache,
    which kinda defeats the purpose.

    This package intends to tackle both issues,
    providing a data type '\''Chimera'\'' for
    lazy infinite compact streams with cache-friendly O(1) indexing.

    Additional features include:

    * memoization of recursive functions and recurrent sequences,
    * memoization of functions of several, possibly signed arguments,
    * efficient memoization of boolean predicates.

category:             Data
abi:                  b6db70ddff3d290030f975ea348abe8c
exposed:              True
exposed-modules:
    Data.Chimera Data.Chimera.ContinuousMapping
    Data.Chimera.WheelMapping

hidden-modules:       Data.Chimera.FromIntegral
import-dirs:          /usr/lib/ghc-9.0.2/site-local/chimera-0.3.3.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/chimera-0.3.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-chimera
hs-libraries:         HSchimera-0.3.3.0-16v0QWF5AX4b1LEwipnyT
depends:
    adjunctions-4.4.2-2vNgNHPGwfiAjRYYNWG4A2 base-4.15.1.0
    distributive-0.6.2.1-JglHNXXzwPGIzyZMyl4KIx mtl-2.2.2
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q transformers-0.5.6.2
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/haskell-chimera/html/chimera.haddock
haddock-html:         /usr/share/doc/haskell-chimera/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

