#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.12.1
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.12.1-G4OfRkAR4UU3f1WnAHQTTB-haskell-ci-internal

key:
    haskell-ci-0.12.1-G4OfRkAR4UU3f1WnAHQTTB-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  0fcd832fc89cc5f8b5f458f738720042
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cli HaskellCI.Compiler
    HaskellCI.Config HaskellCI.Config.ConstraintSet
    HaskellCI.Config.CopyFields HaskellCI.Config.Docspec
    HaskellCI.Config.Doctest HaskellCI.Config.Dump
    HaskellCI.Config.Folds HaskellCI.Config.HLint
    HaskellCI.Config.Installed HaskellCI.Config.Jobs
    HaskellCI.Config.PackageScope HaskellCI.Config.Ubuntu
    HaskellCI.Config.Validity HaskellCI.Diagnostics HaskellCI.Error
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.0.2/site-local/haskell-ci-0.12.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/haskell-ci-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.12.1-G4OfRkAR4UU3f1WnAHQTTB-haskell-ci-internal

depends:
    Cabal-3.4.1.0 HsYAML-0.2.1.1-C3zC5VXXyx5A8HOTbXrF0p
    ShellCheck-0.9.0-4pWXx62W8GwHbHkNvz6MUy
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu
    base16-bytestring-1.0.2.0-9D56NZe6o4J55Lq4iVKJS0 binary-0.8.8.0
    bytestring-0.10.12.1
    cabal-install-parsers-0.4.2-DBju9OHHrLw3NeOG8achXV
    containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-HvF6k2aJaIP1s9SxHh7HNR deepseq-1.4.5.0
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.1
    generic-lens-lite-0.1-5glJveGIXPk7sgczrz8qf2
    indexed-traversable-0.1.2.1-JwIQVWOpW67GVSWDdLo884
    indexed-traversable-instances-0.1.1.2-ITg9ZgLh5kL5mJNTLzSwI3
    ini-0.4.2-AxKzDi6WrYh8uDTzKvZ9iL
    lattices-2.1-L7M88O17elVEhEHjEr1iQS mtl-2.2.2
    network-uri-2.6.4.2-18lVeOrHqdkDTTcK9hqBly
    optparse-applicative-0.17.0.0-1t7fxkFVvXn4R1Ycov0fb parsec-3.1.14.0
    pretty-1.1.3.6 process-1.6.13.2
    temporary-1.3-Bh4fczMTiyN6QOEVSScDYk text-1.2.5.0
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    zinza-0.2-KCbo5YutaSz4vbJnC4MzKo

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

