#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-lib
version:              1.6.4
visibility:           public
id:                   clash-lib-1.6.4-LRLG3IlIFusFE7jDfY4XGV
key:                  clash-lib-1.6.4-LRLG3IlIFusFE7jDfY4XGV
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  38b6922b5524595e2e7b822800850a69
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Core.DataCon Clash.Core.EqSolver
    Clash.Core.Evaluator.Types Clash.Core.FreeVars
    Clash.Core.HasFreeVars Clash.Core.HasType Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH Clash.Core.TyCon
    Clash.Core.Type Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var
    Clash.Core.VarEnv Clash.Debug Clash.Driver Clash.Driver.Manifest
    Clash.Driver.Types Clash.Edalize.Edam Clash.Netlist
    Clash.Netlist.BlackBox Clash.Netlist.BlackBox.Parser
    Clash.Netlist.BlackBox.Types Clash.Netlist.BlackBox.Util
    Clash.Netlist.Id Clash.Netlist.Id.Common Clash.Netlist.Id.Internal
    Clash.Netlist.Id.SystemVerilog Clash.Netlist.Id.VHDL
    Clash.Netlist.Id.Verilog Clash.Netlist.Types Clash.Netlist.Util
    Clash.Normalize Clash.Normalize.PrimitiveReductions
    Clash.Normalize.Primitives Clash.Normalize.Strategy
    Clash.Normalize.Transformations Clash.Normalize.Transformations.ANF
    Clash.Normalize.Transformations.Case
    Clash.Normalize.Transformations.Cast
    Clash.Normalize.Transformations.DEC
    Clash.Normalize.Transformations.EtaExpand
    Clash.Normalize.Transformations.Inline
    Clash.Normalize.Transformations.Letrec
    Clash.Normalize.Transformations.MultiPrim
    Clash.Normalize.Transformations.Reduce
    Clash.Normalize.Transformations.SeparateArgs
    Clash.Normalize.Transformations.Specialize
    Clash.Normalize.Transformations.XOptimize Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty Clash.Primitives.DSL
    Clash.Primitives.GHC.Int Clash.Primitives.GHC.Literal
    Clash.Primitives.GHC.Word Clash.Primitives.Intel.ClockGen
    Clash.Primitives.Sized.Signed Clash.Primitives.Sized.ToInteger
    Clash.Primitives.Sized.Vector Clash.Primitives.Types
    Clash.Primitives.Util Clash.Primitives.Verification
    Clash.Rewrite.Combinators Clash.Rewrite.Types Clash.Rewrite.Util
    Clash.Rewrite.WorkFree Clash.Unique Clash.Util Clash.Util.Eq
    Clash.Util.Graph Clash.Util.Interpolate Clash.Verification.Pretty
    Data.Aeson.Extra Data.Text.Prettyprint.Doc.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Data.IntMap.Extra Data.List.Extra
    Data.Map.Ordered.Extra Data.Monoid.Extra
    Data.Primitive.ByteArray.Extra Data.Set.Ordered.Extra
    Data.Text.Extra GHC.BasicTypes.Extra GHC.SrcLoc.Extra
    Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.0.2/site-local/clash-lib-1.6.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/clash-lib-1.6.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-lib
hs-libraries:         HSclash-lib-1.6.4-LRLG3IlIFusFE7jDfY4XGV
depends:
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    aeson-pretty-0.8.9-5lTV2yokao3rqi6vQJbJu
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk array-0.5.4.0
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base16-bytestring-1.0.2.0-9D56NZe6o4J55Lq4iVKJS0 binary-0.8.8.0
    bytestring-0.10.12.1 clash-prelude-1.6.4-LvCI9PdV30e9weB5WF8jpD
    concurrent-supply-0.1.8-FnFfIAOi1iF2SYzU7ubWSa containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-HvF6k2aJaIP1s9SxHh7HNR
    data-binary-ieee754-0.4.4-6nKeQnWkGoLJGejCHaRaWS
    data-default-0.7.1.1-8E5NGoO1gLxEpVTFDWBmYU deepseq-1.4.5.0
    directory-1.3.6.2 dlist-1.0-JalAZsGq1LOCqqdFHHEpoL
    exceptions-0.10.4 extra-1.7.13-HYX6gpOPDmAIHqUj1ljVuZ
    filepath-1.4.2.1 ghc-9.0.2 ghc-bignum-1.1 ghc-boot-th-9.0.2
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    haskell-src-meta-0.8.11-E7yhcoWLqOM9TXy5aQbtoY
    hint-0.9.0.6-4XHzgmCt90Z8XK6nnRMsUD
    interpolate-0.2.1-Llh8ip4HaKIJrs6O2RnPPY
    lens-5.2.2-4uj1AepANiF2ook39zjsmk mtl-2.2.2
    ordered-containers-0.2.3-1tstpx5kksg3nCXqs5HGNP
    pretty-show-1.10-E9zv3yZn35Y9VpF8wkb8MR
    prettyprinter-1.7.1-9bwAyMlaUSyJVG7FMXWGKT
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q template-haskell-2.17.0.0
    temporary-1.3-Bh4fczMTiyN6QOEVSScDYk
    terminal-size-0.3.4-35v8zhylKTKAMnavZT32Cm text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 trifecta-2.1.2-5Sfhi53tOGvDYH07jJUzrl
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    vector-binary-instances-0.2.5.2-FkMHYNFVClkB8qKie4frAy
    yaml-0.11.11.2-HMJi93sq55j29LTuvNA0C1

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

