#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 curve25519
version:              0.2.7
visibility:           public
id:                   curve25519-0.2.7-I4NMRvj5vmk65awGhXSnnF
key:                  curve25519-0.2.7-I4NMRvj5vmk65awGhXSnnF
license:              BSD-3-Clause
maintainer:           Adam Wick <awick@uhsure.com>
author:               Adam Wick <awick@uhsure.com>
homepage:             http://github.com/acw/curve25519
synopsis:
    Fast implementations of the curve25519 elliptic curve primitives.

description:
    Haskell bindings and extensions to the curve25519-donna
    codebase. This module is a pretty straightforward implementation
    of the basic cryptographic routines you'\''d want from a project that
    uses curve25519: key generation, and key agreement. For further
    functionality, you'\''ll want to look elsewhere.

category:             Math
abi:                  ab443c51e7e5ba9f5eecc8caa6ae9908
exposed:              True
exposed-modules:
    Crypto.Curve25519 Crypto.Curve25519.Exceptions
    Crypto.Curve25519.Pure

import-dirs:          /usr/lib/ghc-9.0.2/site-local/curve25519-0.2.7
library-dirs:         /usr/lib/ghc-9.0.2/site-local/curve25519-0.2.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-curve25519
hs-libraries:         HScurve25519-0.2.7-I4NMRvj5vmk65awGhXSnnF
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    crypto-api-0.13.3-EHPdhbKdFzpJPwJ37IaBSu

haddock-interfaces:   /usr/share/doc/haskell-curve25519/html/curve25519.haddock
haddock-html:         /usr/share/doc/haskell-curve25519/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

