#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dbus
version:              1.2.22
visibility:           public
id:                   dbus-1.2.22-4aPnULQzBVW8f2vFMszzZ4
key:                  dbus-1.2.22-4aPnULQzBVW8f2vFMszzZ4
license:              Apache-2.0
maintainer:           Andrey Sverdlichenko <blaze@ruddy.ru>
author:               John Millikin <john@john-millikin.com>
stability:            experimental
homepage:             https://github.com/rblaze/haskell-dbus#readme
synopsis:             A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.

    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.

    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.

    Example: connect to the session bus, and get a list of active names.

    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;

    import Data.List (sort)
    import DBus
    import DBus.Client

    main = do
    &#x20;   client <- connectSession
    &#x20;
    &#x20;   -- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;
    &#x20;   -- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   -- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;
    &#x20;   -- Print each name on a line, sorted so reserved names are below
    &#x20;   -- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @

    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver

category:             Network, Desktop
abi:                  ab9312c2a2d5adb68ecd1c6431c9c22c
exposed:              True
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Introspection.Parse
    DBus.Introspection.Render DBus.Introspection.Types DBus.Socket
    DBus.TH DBus.Transport

import-dirs:          /usr/lib/ghc-9.0.2/site-local/dbus-1.2.22
library-dirs:         /usr/lib/ghc-9.0.2/site-local/dbus-1.2.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-dbus
hs-libraries:         HSdbus-1.2.22-4aPnULQzBVW8f2vFMszzZ4
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    cereal-0.5.8.3-KCibhvvTsuv86wVgcPkD6
    conduit-1.3.5-Jq81tBeR2eG6Vm9Wfmg9Au containers-0.6.4.1
    deepseq-1.4.5.0 exceptions-0.10.4 filepath-1.4.2.1
    lens-5.2.2-4uj1AepANiF2ook39zjsmk
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq parsec-3.1.14.0
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf template-haskell-2.17.0.0
    text-1.2.5.0 th-lift-0.8.4-4cyXLgXzVomInnuNEFv3vJ
    transformers-0.5.6.2 unix-2.7.2.2
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    xml-conduit-1.9.1.3-FXhjiZfXbw4LbDReANXEOS
    xml-types-0.3.8-5QCBKSWiifmEtQB2jlqHYu

haddock-interfaces:   /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html:         /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

