#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 equivalence
version:              0.4.1
visibility:           public
id:                   equivalence-0.4.1-KGnyf2CYbVYFGfi26WpAVI
key:                  equivalence-0.4.1-KGnyf2CYbVYFGfi26WpAVI
license:              BSD-3-Clause
maintainer:           Andreas Abel
author:               Patrick Bahr
stability:            provisional
homepage:             https://github.com/pa-ba/equivalence
synopsis:
    Maintaining an equivalence relation implemented as union-find using STT.

description:
    This is an implementation of Tarjan'\''s Union-Find algorithm (Robert
    E. Tarjan. "Efficiency of a Good But Not Linear Set Union
    Algorithm", JACM 22(2), 1975) in order to maintain an equivalence
    relation.
    This implementation is a port of the /union-find/ package using the
    ST monad transformer (instead of the IO monad).

category:             Algorithms, Data
abi:                  190030bcdf2eeae6145f17f7649d0dfd
exposed:              True
exposed-modules:      Data.Equivalence.Monad Data.Equivalence.STT
import-dirs:          /usr/lib/ghc-9.0.2/site-local/equivalence-0.4.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/equivalence-0.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-equivalence
hs-libraries:         HSequivalence-0.4.1-KGnyf2CYbVYFGfi26WpAVI
depends:
    STMonadTrans-0.4.7-BsZGbweKkrz7Kfx4MzqdFx base-4.15.1.0
    containers-0.6.4.1 mtl-2.2.2 transformers-0.5.6.2
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH

haddock-interfaces:   /usr/share/doc/haskell-equivalence/html/equivalence.haddock
haddock-html:         /usr/share/doc/haskell-equivalence/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

