#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 esqueleto
version:              3.5.7.1
visibility:           public
id:                   esqueleto-3.5.7.1-Fpvd8l1I63RCHXLMuvcM6q
key:                  esqueleto-3.5.7.1-Fpvd8l1I63RCHXLMuvcM6q
license:              BSD-3-Clause
copyright:            (c) 2012-2016 Felipe Almeida Lessa
maintainer:           cma@bitemyapp.com
author:               Felipe Lessa
homepage:             https://github.com/bitemyapp/esqueleto
synopsis:             Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.

    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)

    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.

    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.

category:             Database
abi:                  6bb65f43d853698e4dc0de41f1c3a418
exposed:              True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Experimental
    Database.Esqueleto.Experimental.From
    Database.Esqueleto.Experimental.From.CommonTableExpression
    Database.Esqueleto.Experimental.From.Join
    Database.Esqueleto.Experimental.From.SqlSetOperation
    Database.Esqueleto.Experimental.ToAlias
    Database.Esqueleto.Experimental.ToAliasReference
    Database.Esqueleto.Experimental.ToMaybe
    Database.Esqueleto.Internal.ExprParser
    Database.Esqueleto.Internal.Internal Database.Esqueleto.Legacy
    Database.Esqueleto.MySQL Database.Esqueleto.PostgreSQL
    Database.Esqueleto.PostgreSQL.JSON Database.Esqueleto.Record
    Database.Esqueleto.SQLite

hidden-modules:
    Database.Esqueleto.PostgreSQL.JSON.Instances
    Database.Esqueleto.Internal.PersistentImport Paths_esqueleto

import-dirs:          /usr/lib/ghc-9.0.2/site-local/esqueleto-3.5.7.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/esqueleto-3.5.7.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-esqueleto
hs-libraries:         HSesqueleto-3.5.7.1-Fpvd8l1I63RCHXLMuvcM6q
depends:
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    blaze-html-0.9.1.2-CjGwhvVZpiI2yqci6C0Ey8 bytestring-0.10.12.1
    conduit-1.3.5-Jq81tBeR2eG6Vm9Wfmg9Au containers-0.6.4.1
    monad-logger-0.3.40-4Vc4L87sLQmP1u9MaXupj
    persistent-2.13.3.5-6mHmAoq8BCIF1tCfpXnqYO
    resourcet-1.2.6-AavQnD5kc82Iq3gAOb9Jer
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf template-haskell-2.17.0.0
    text-1.2.5.0 time-1.9.3 transformers-0.5.6.2
    unliftio-0.2.24.0-KW7QcS6oOTdEVZjzWJlJSE
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz

haddock-interfaces:   /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html:         /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

