#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 extra
version:              1.7.13
visibility:           public
id:                   extra-1.7.13-HYX6gpOPDmAIHqUj1ljVuZ
key:                  extra-1.7.13-HYX6gpOPDmAIHqUj1ljVuZ
license:              BSD-3-Clause
copyright:            Neil Mitchell 2014-2023
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://github.com/ndmitchell/extra#readme
synopsis:             Extra functions I use.
description:
    A library of extra functions for the standard Haskell libraries. Most functions are simple additions, filling out missing functionality. A few functions are available in later versions of GHC, but this package makes them available back to GHC 7.2.

    The module "Extra" documents all functions provided by this library. Modules such as "Data.List.Extra" provide extra functions over "Data.List" and also reexport "Data.List". Users are recommended to replace "Data.List" imports with "Data.List.Extra" if they need the extra functionality.

category:             Development
abi:                  e5058df2ddb916e09f1adbc269bdfa8e
exposed:              True
exposed-modules:
    Control.Concurrent.Extra Control.Exception.Extra
    Control.Monad.Extra Data.Either.Extra Data.Foldable.Extra
    Data.IORef.Extra Data.List.Extra Data.List.NonEmpty.Extra
    Data.Monoid.Extra Data.Tuple.Extra Data.Typeable.Extra
    Data.Version.Extra Extra Numeric.Extra System.Directory.Extra
    System.Environment.Extra System.IO.Extra System.Info.Extra
    System.Process.Extra System.Time.Extra Text.Read.Extra

hidden-modules:       Partial
import-dirs:          /usr/lib/ghc-9.0.2/site-local/extra-1.7.13
library-dirs:         /usr/lib/ghc-9.0.2/site-local/extra-1.7.13
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-extra
hs-libraries:         HSextra-1.7.13-HYX6gpOPDmAIHqUj1ljVuZ
depends:
    base-4.15.1.0 clock-0.8.3-2U80sdDOrjmBlVZLInPGG1 directory-1.3.6.2
    filepath-1.4.2.1 process-1.6.13.2 time-1.9.3 unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-extra/html/extra.haddock
haddock-html:         /usr/share/doc/haskell-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

