#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 filepath-bytestring
version:              1.4.2.1.9
visibility:           public
id:                   filepath-bytestring-1.4.2.1.9-Jx9bzFgstaYGtQBZSGd6aM
key:                  filepath-bytestring-1.4.2.1.9-Jx9bzFgstaYGtQBZSGd6aM
license:              BSD-3-Clause
copyright:
    Neil Mitchell 2005-2019
    Joey Hess 2019-2021

maintainer:           Joey Hess <id@joeyh.name>
author:               Neil Mitchell <ndmitchell@gmail.com>
synopsis:
    Library for manipulating RawFilePaths in a cross platform way.

description:
    This package provides functionality for manipulating @RawFilePath@
    values. It can be used as a drop in replacement for the filepath library
    to get the benefits of using ByteStrings. It provides three modules:

    * "System.FilePath.Posix.ByteString" manipulates POSIX\/Linux style @RawFilePath@ values (with @\/@ as the path separator).

    * "System.FilePath.Windows.ByteString" manipulates Windows style @RawFilePath@ values (with either @\\@ or @\/@ as the path separator, and deals with drives).

    * "System.FilePath.ByteString" is an alias for the module appropriate to your platform.

    All three modules provide the same API, and the same documentation (calling out differences in the different variants).

category:             System
abi:                  2f2d659e35322487f4c2c9983b7b3b88
exposed:              True
exposed-modules:
    System.FilePath.ByteString System.FilePath.Posix.ByteString
    System.FilePath.Windows.ByteString

import-dirs:          /usr/lib/ghc-9.0.2/site-local/filepath-bytestring-1.4.2.1.9
library-dirs:         /usr/lib/ghc-9.0.2/site-local/filepath-bytestring-1.4.2.1.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-filepath-bytestring
hs-libraries:         HSfilepath-bytestring-1.4.2.1.9-Jx9bzFgstaYGtQBZSGd6aM
depends:              base-4.15.1.0 bytestring-0.10.12.1 unix-2.7.2.2
haddock-interfaces:
    /usr/share/doc/haskell-filepath-bytestring/html/filepath-bytestring.haddock

haddock-html:         /usr/share/doc/haskell-filepath-bytestring/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

