#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 fin
version:              0.3
visibility:           public
id:                   fin-0.3-InZwebmfZLj78okgHGpyyr
key:                  fin-0.3-InZwebmfZLj78okgHGpyyr
license:              BSD-3-Clause
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Nat and Fin: peano naturals and finite numbers
description:
    This package provides two simple types, and some tools to work with them.
    Also on type level as @DataKinds@.

    @
    \-- Peano naturals
    data Nat = Z | S Nat

    \-- Finite naturals
    data Fin (n :: Nat) where
    \    Z :: Fin ('\''S n)
    \    S :: Fin n -> Fin ('\''Nat.S n)
    @

    [vec](https://hackage.haskell.org/package/vec) implements length-indexed
    (sized) lists using this package for indexes.

    The "Data.Fin.Enum" module let'\''s work generically with enumerations.

    See [Hasochism: the pleasure and pain of dependently typed haskell programming](https://doi.org/10.1145/2503778.2503786)
    by Sam Lindley and Conor McBride for answers to /how/ and /why/.
    Read [APLicative Programming with Naperian Functors](https://doi.org/10.1007/978-3-662-54434-1_21)
    by Jeremy Gibbons for (not so) different ones.

    === Similar packages

    * [finite-typelits](https://hackage.haskell.org/package/finite-typelits)
    . Is a great package, but uses @GHC.TypeLits@.

    * [type-natural](https://hackage.haskell.org/package/type-natural) depends
    on @singletons@ package. @fin@ will try to stay light on the dependencies,
    and support as many GHC versions as practical.

    * [peano](https://hackage.haskell.org/package/peano) is very incomplete

    * [nat](https://hackage.haskell.org/package/nat) as well.

    * [PeanoWitnesses](https://hackage.haskell.org/package/PeanoWitnesses)
    doesn'\''t use @DataKinds@.

    * [type-combinators](https://hackage.haskell.org/package/type-combinators)
    is big package too.

category:             Data, Dependent Types, Singletons, Math
abi:                  3ae8baa690820a5ffb79833a25b62b1a
exposed:              True
exposed-modules:
    Data.Fin Data.Nat Data.Type.Nat Data.Type.Nat.LE
    Data.Type.Nat.LE.ReflStep Data.Type.Nat.LT

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.0.2/site-local/fin-0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/fin-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-fin
hs-libraries:         HSfin-0.3-InZwebmfZLj78okgHGpyyr
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4 base-4.15.1.0
    boring-0.2.1-A8wgoiDmgwXAhCQHRXaSX4
    dec-0.0.5-EMy4RqsyQ6VJ3jWA1xpkJp deepseq-1.4.5.0
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    some-1.0.5-2CCxSGFRQ8m3FjAx9nXmXm
    universe-base-1.1.3.1-EGGaoKbtfkjBEOFM7P5P0T

haddock-interfaces:   /usr/share/doc/haskell-fin/html/fin.haddock
haddock-html:         /usr/share/doc/haskell-fin/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

