#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ghc-typelits-knownnat
version:              0.7.7
visibility:           public
id:                   ghc-typelits-knownnat-0.7.7-6v81Dmm0u0qBvUWhnfaCHB
key:                  ghc-typelits-knownnat-0.7.7-6v81Dmm0u0qBvUWhnfaCHB
license:              BSD-2-Clause
copyright:
    Copyright © 2016     , University of Twente,
    2017-2018, QBayLogic B.V.,
    2017     , Google Inc.

maintainer:           christiaan.baaij@gmail.com
author:               Christiaan Baaij
homepage:             http://clash-lang.org/
synopsis:             Derive KnownNat constraints from other KnownNat constraints
description:
    A type checker plugin for GHC that can derive \"complex\" @KnownNat@
    constraints from other simple/variable @KnownNat@ constraints. i.e. without
    this plugin, you must have both a @KnownNat n@ and a @KnownNat (n+2)@
    constraint in the type signature of the following function:

    @
    f :: forall n . (KnownNat n, KnownNat (n+2)) => Proxy n -> Integer
    f _ = natVal (Proxy :: Proxy n) + natVal (Proxy :: Proxy (n+2))
    @

    Using the plugin you can omit the @KnownNat (n+2)@ constraint:

    @
    f :: forall n . KnownNat n => Proxy n -> Integer
    f _ = natVal (Proxy :: Proxy n) + natVal (Proxy :: Proxy (n+2))
    @

    The plugin can derive @KnownNat@ constraints for types consisting of:

    * Type variables, when there is a corresponding @KnownNat@ constraint

    * Type-level naturals

    * Applications of the arithmetic expression: +,-,*,^

    * Type functions, when there is either:

    1. a matching given @KnownNat@ constraint; or

    2. a corresponding @KnownNat\<N\>@ instance for the type function

    To use the plugin, add the

    @
    OPTIONS_GHC -fplugin GHC.TypeLits.KnownNat.Solver
    @

    Pragma to the header of your file.

category:             Type System
abi:                  48943229583a836de42a31c0c7a5308d
exposed:              True
exposed-modules:      GHC.TypeLits.KnownNat GHC.TypeLits.KnownNat.Solver
hidden-modules:       GHC.TypeLits.KnownNat.TH
import-dirs:          /usr/lib/ghc-9.0.2/site-local/ghc-typelits-knownnat-0.7.7
library-dirs:         /usr/lib/ghc-9.0.2/site-local/ghc-typelits-knownnat-0.7.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ghc-typelits-knownnat
hs-libraries:         HSghc-typelits-knownnat-0.7.7-6v81Dmm0u0qBvUWhnfaCHB
depends:
    base-4.15.1.0 ghc-9.0.2 ghc-prim-0.7.0
    ghc-tcplugins-extra-0.4.4-BdjzAEpCoq319p96K3jj6Y
    ghc-typelits-natnormalise-0.7.7-E4pdflb1NM3GslIbb9clu6
    template-haskell-2.17.0.0 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-ghc-typelits-knownnat/html/ghc-typelits-knownnat.haddock

haddock-html:         /usr/share/doc/haskell-ghc-typelits-knownnat/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

