#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 gi-cairo-render
version:              0.1.2
visibility:           public
id:                   gi-cairo-render-0.1.2-LktzqaiBv31JtbR8oLCK7m
key:                  gi-cairo-render-0.1.2-LktzqaiBv31JtbR8oLCK7m
license:              BSD-3-Clause
copyright:
    (c) 2018 Kilian Kilger, (c) 2001-2010 The Gtk2Hs Team, (c) Paolo Martini 2005, (c) Abraham Egnor 2003, 2004, (c) Aetion Technologies LLC 2004

maintainer:           Kilian Kilger (kkilger@gmail.com)
author:               Axel Simon, Duncan Coutts
stability:            experimental
homepage:             https://github.com/cohomology/gi-cairo-render
synopsis:             GI friendly Binding to the Cairo library.
description:
    Cairo is a library to render high quality vector graphics. There
    exist various backends that allows rendering to Gtk windows, PDF,
    PS, PNG and SVG documents, amongst others.

category:             Graphics
abi:                  932a5703f330e20b2297bb79704f7eaf
exposed:              True
exposed-modules:
    GI.Cairo.Render GI.Cairo.Render.Internal GI.Cairo.Render.Matrix
    GI.Cairo.Render.Types

hidden-modules:
    GI.Cairo.Render.Internal.Drawing.Cairo
    GI.Cairo.Render.Internal.Drawing.Paths
    GI.Cairo.Render.Internal.Drawing.Patterns
    GI.Cairo.Render.Internal.Drawing.Text
    GI.Cairo.Render.Internal.Drawing.Transformations
    GI.Cairo.Render.Internal.Fonts.FontOptions
    GI.Cairo.Render.Internal.Surfaces.Image
    GI.Cairo.Render.Internal.Surfaces.PNG
    GI.Cairo.Render.Internal.Surfaces.Surface
    GI.Cairo.Render.Internal.Utilities
    GI.Cairo.Render.Internal.Surfaces.PDF
    GI.Cairo.Render.Internal.Surfaces.PS
    GI.Cairo.Render.Internal.Surfaces.SVG
    GI.Cairo.Render.Internal.Region

import-dirs:          /usr/lib/ghc-9.0.2/site-local/gi-cairo-render-0.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/gi-cairo-render-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-gi-cairo-render
hs-libraries:         HSgi-cairo-render-0.1.2-LktzqaiBv31JtbR8oLCK7m
extra-libraries:      cairo-gobject gobject-2.0 glib-2.0 z cairo png16
include-dirs:
    /usr/include/cairo /usr/include/libpng16 /usr/include/freetype2
    /usr/include/harfbuzz /usr/include/glib-2.0
    /usr/lib/glib-2.0/include /usr/include/sysprof-4
    /usr/include/pixman-1

depends:
    array-0.5.4.0 base-4.15.1.0 bytestring-0.10.12.1
    haskell-gi-base-0.26.3-F9RrvzwFZ6b9FvkaVvE8dw mtl-2.2.2
    text-1.2.5.0 utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO

haddock-interfaces:
    /usr/share/doc/haskell-gi-cairo-render/html/gi-cairo-render.haddock

haddock-html:         /usr/share/doc/haskell-gi-cairo-render/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

