#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 graphviz
version:              2999.20.1.0
visibility:           public
id:                   graphviz-2999.20.1.0-5ev0fTu8bKGGXF30wtP8d6
key:                  graphviz-2999.20.1.0-5ev0fTu8bKGGXF30wtP8d6
license:              BSD-3-Clause
copyright:            Matthew Sackman, Ivan Lazar Miljenovic
maintainer:           Ivan.Miljenovic@gmail.com
author:               Matthew Sackman, Ivan Lazar Miljenovic
stability:            Beta
homepage:             https://github.com/ivan-m/graphviz
synopsis:             Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.

    Main features of the graphviz library include:

    * Almost complete coverage of all Graphviz attributes and syntax.

    * Support for specifying clusters.

    * The ability to use a custom node type.

    * Functions for running a Graphviz layout tool with all specified
    output types.

    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).

    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.

    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.

category:             Graphs, Graphics
abi:                  60c4617bcdb0741d1c1d3a6aa4d01239
exposed:              True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic

hidden-modules:
    Data.GraphViz.Algorithms.Clustering Data.GraphViz.Attributes.Arrows
    Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
    Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
    Data.GraphViz.Types.State

import-dirs:          /usr/lib/ghc-9.0.2/site-local/graphviz-2999.20.1.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/graphviz-2999.20.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-graphviz
hs-libraries:         HSgraphviz-2999.20.1.0-5ev0fTu8bKGGXF30wtP8d6
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    colour-2.3.6-EuYv2zipv8X3m9Cp1zQHEC containers-0.6.4.1
    directory-1.3.6.2 dlist-1.0-JalAZsGq1LOCqqdFHHEpoL
    fgl-5.8.1.1-G5eZtoO8UpB7kWXByxLELz filepath-1.4.2.1 mtl-2.2.2
    polyparse-1.13-6qWX0TBgzpT5PvWL8guBB0 process-1.6.13.2
    temporary-1.3-Bh4fczMTiyN6QOEVSScDYk text-1.2.5.0
    wl-pprint-text-1.2.0.2-8n3vZc9ip0m5MsdNGvqp8K

haddock-interfaces:   /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html:         /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

