#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hackage-security
version:              0.6.2.3
visibility:           public
id:                   hackage-security-0.6.2.3-HdLZ2SxXB4oDb9enOMgNsJ
key:                  hackage-security-0.6.2.3-HdLZ2SxXB4oDb9enOMgNsJ
license:              BSD-3-Clause
copyright:            Copyright 2015-2022 Well-Typed LLP
maintainer:           cabal-devel@haskell.org
author:               Edsko de Vries
homepage:             https://github.com/haskell/hackage-security
synopsis:             Hackage security library
description:
    The hackage security library provides both server and
    client utilities for securing the Hackage package server
    (<https://hackage.haskell.org/>).  It is based on The Update
    Framework (<https://theupdateframework.com/>), a set of
    recommendations developed by security researchers at
    various universities in the US as well as developers on the
    Tor project (<https://www.torproject.org/>).

    The current implementation supports only index signing,
    thereby enabling untrusted mirrors. It does not yet provide
    facilities for author package signing.

    The library has two main entry points:
    "Hackage.Security.Client" is the main entry point for
    clients (the typical example being @cabal@), and
    "Hackage.Security.Server" is the main entry point for
    servers (the typical example being @hackage-server@).

category:             Distribution
abi:                  12a3daee9aa9b468c3dac613462a58ed
exposed:              True
exposed-modules:
    Hackage.Security.Client Hackage.Security.Client.Formats
    Hackage.Security.Client.Repository
    Hackage.Security.Client.Repository.Cache
    Hackage.Security.Client.Repository.HttpLib
    Hackage.Security.Client.Repository.Local
    Hackage.Security.Client.Repository.Remote
    Hackage.Security.Client.Verify Hackage.Security.JSON
    Hackage.Security.Key.Env Hackage.Security.Server
    Hackage.Security.TUF.FileMap Hackage.Security.Trusted
    Hackage.Security.Util.Checked Hackage.Security.Util.Path
    Hackage.Security.Util.Pretty Hackage.Security.Util.Some
    Text.JSON.Canonical

hidden-modules:
    Hackage.Security.Key Hackage.Security.Trusted.TCB
    Hackage.Security.TUF Hackage.Security.TUF.Common
    Hackage.Security.TUF.FileInfo Hackage.Security.TUF.Header
    Hackage.Security.TUF.Layout.Cache Hackage.Security.TUF.Layout.Index
    Hackage.Security.TUF.Layout.Repo Hackage.Security.TUF.Mirrors
    Hackage.Security.TUF.Paths Hackage.Security.TUF.Patterns
    Hackage.Security.TUF.Root Hackage.Security.TUF.Signed
    Hackage.Security.TUF.Snapshot Hackage.Security.TUF.Targets
    Hackage.Security.TUF.Timestamp Hackage.Security.Util.Base64
    Hackage.Security.Util.Exit Hackage.Security.Util.IO
    Hackage.Security.Util.JSON Hackage.Security.Util.Lens
    Hackage.Security.Util.Stack Hackage.Security.Util.TypedEmbedded
    MyPrelude

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hackage-security-0.6.2.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hackage-security-0.6.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hackage-security
hs-libraries:         HShackage-security-0.6.2.3-HdLZ2SxXB4oDb9enOMgNsJ
depends:
    Cabal-3.4.1.0 base-4.15.1.0
    base16-bytestring-1.0.2.0-9D56NZe6o4J55Lq4iVKJS0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En
    bytestring-0.10.12.1 containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-HvF6k2aJaIP1s9SxHh7HNR
    directory-1.3.6.2 ed25519-0.0.5.0-6yAj5y2BEF11CQnEG85jY3
    filepath-1.4.2.1 ghc-prim-0.7.0
    lukko-0.1.1.3-7KfbXz8qakVC7BFqe5HDLn mtl-2.2.2
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    network-uri-2.6.4.2-18lVeOrHqdkDTTcK9hqBly parsec-3.1.14.0
    pretty-1.1.3.6 tar-0.5.1.1-JG2bbw94OU9AYRET86kdq3
    template-haskell-2.17.0.0 time-1.9.3 transformers-0.5.6.2
    zlib-0.6.3.0-5MlrrAbgjA8AXbUw8xgJze

haddock-interfaces:
    /usr/share/doc/haskell-hackage-security/html/hackage-security.haddock

haddock-html:         /usr/share/doc/haskell-hackage-security/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

