#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 haddock-library
version:              1.10.0
visibility:           public
id:                   haddock-library-1.10.0-GWiZs4jdAbbKkJIRVZwGyN
key:                  haddock-library-1.10.0-GWiZs4jdAbbKkJIRVZwGyN
license:              BSD-2-Clause
maintainer:
    Alec Theriault <alec.theriault@gmail.com>, Alex Biehl <alexbiehl@gmail.com>, Simon Hengel <sol@typeful.net>, Mateusz Kowalczyk <fuuzetsu@fuuzetsu.co.uk>

homepage:             http://www.haskell.org/haddock/
synopsis:             Library exposing some functionality of Haddock.
description:
    Haddock is a documentation-generation tool for Haskell
    libraries. These modules expose some
    functionality of it without pulling in the GHC
    dependency. Please note that the API is likely
    to change so be sure to specify upper bounds in
    your projects. For interacting with Haddock
    itself, see the [haddock package](https://hackage.haskell.org/package/haddock).

category:             Documentation
abi:                  2a908674b3143b99759b181f6d7d1c07
exposed:              True
exposed-modules:
    Documentation.Haddock.Doc Documentation.Haddock.Markup
    Documentation.Haddock.Parser Documentation.Haddock.Types

hidden-modules:
    CompatPrelude Documentation.Haddock.Parser.Util
    Documentation.Haddock.Parser.Monad
    Documentation.Haddock.Parser.Identifier

import-dirs:          /usr/lib/ghc-9.0.2/site-local/haddock-library-1.10.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/haddock-library-1.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-haddock-library
hs-libraries:         HShaddock-library-1.10.0-GWiZs4jdAbbKkJIRVZwGyN
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    parsec-3.1.14.0 text-1.2.5.0 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-haddock-library/html/haddock-library.haddock

haddock-html:         /usr/share/doc/haskell-haddock-library/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

