#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hedgehog
version:              1.1.2
visibility:           public
id:                   hedgehog-1.1.2-7RW6IfGcjE76qeu2XyN6uQ
key:                  hedgehog-1.1.2-7RW6IfGcjE76qeu2XyN6uQ
license:              BSD-3-Clause
maintainer:           Jacob Stanley <jacob@stanley.io>
author:               Jacob Stanley
homepage:             https://hedgehog.qa
synopsis:             Release with confidence.
description:
    <http://hedgehog.qa/ Hedgehog> automatically generates a comprehensive array
    of test cases, exercising your software in ways human testers would never
    imagine.

    Generate hundreds of test cases automatically, exposing even the
    most insidious of corner cases. Failures are automatically simplified, giving
    developers coherent, intelligible error messages.

    To get started quickly, see the <https://github.com/hedgehogqa/haskell-hedgehog/tree/master/hedgehog-example examples>.

category:             Testing
abi:                  a89e0782e77f6c092aba624e8b9ed949
exposed:              True
exposed-modules:
    Hedgehog Hedgehog.Gen Hedgehog.Internal.Barbie
    Hedgehog.Internal.Config Hedgehog.Internal.Discovery
    Hedgehog.Internal.Distributive Hedgehog.Internal.Exception
    Hedgehog.Internal.Gen Hedgehog.Internal.HTraversable
    Hedgehog.Internal.Opaque Hedgehog.Internal.Prelude
    Hedgehog.Internal.Property Hedgehog.Internal.Queue
    Hedgehog.Internal.Range Hedgehog.Internal.Region
    Hedgehog.Internal.Report Hedgehog.Internal.Runner
    Hedgehog.Internal.Seed Hedgehog.Internal.Show
    Hedgehog.Internal.Shrink Hedgehog.Internal.Source
    Hedgehog.Internal.State Hedgehog.Internal.TH Hedgehog.Internal.Tree
    Hedgehog.Internal.Tripping Hedgehog.Main Hedgehog.Range

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hedgehog-1.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hedgehog-1.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hedgehog
hs-libraries:         HShedgehog-1.1.2-7RW6IfGcjE76qeu2XyN6uQ
depends:
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4
    barbies-2.0.4.0-2WObAzoyLmc3QKsNFh3ZMx base-4.15.1.0
    bytestring-0.10.12.1
    concurrent-output-1.10.18-6XXtm8WgFrPLuk4ZiH8lMg containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.2
    erf-2.0.0.0-HR6qYigvkwv59tgVmdiMH1 exceptions-0.10.4
    lifted-async-0.10.2.4-UgmdgdXwbhEMugMY6bG16
    mmorph-1.2.0-2iQgHTViuScASaZTADZaI1
    monad-control-1.0.3.1-35h1aVdsL57202S8tnbNU9 mtl-2.2.2
    pretty-show-1.10-E9zv3yZn35Y9VpF8wkb8MR
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    resourcet-1.2.6-AavQnD5kc82Iq3gAOb9Jer stm-2.5.0.0
    template-haskell-2.17.0.0 text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 transformers-base-0.4.6-92OnlKVmSzm7Q6K6Tg9Pzs
    wl-pprint-annotated-0.1.0.1-149INS3WML6EjlKydyQa

haddock-interfaces:   /usr/share/doc/haskell-hedgehog/html/hedgehog.haddock
haddock-html:         /usr/share/doc/haskell-hedgehog/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

