#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-lib
version:              1.29.1
visibility:           public
id:                   hledger-lib-1.29.1-Cpyc2blrNRI6OQj2h9lrC6
key:                  hledger-lib-1.29.1-Cpyc2blrNRI6OQj2h9lrC6
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:
    A reusable library providing the core functionality of hledger

description:
    A reusable library containing hledger'\''s core functionality.
    This is used by most hledger* packages so that they support the same
    common file formats, command line options, reports etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  49203dc72034411a1794e11841a16ec8
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.TimeclockReader Hledger.Read.TimedotReader
    Hledger.Reports Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-lib-1.29.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-lib-1.29.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.29.1-Cpyc2blrNRI6OQj2h9lrC6
depends:
    Decimal-0.5.2-JuUDSdXwdHw807z3DuaA9c
    Glob-0.10.2-3nVoBiOJijA9OiBj5S4ual
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    aeson-pretty-0.8.9-5lTV2yokao3rqi6vQJbJu
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk array-0.5.4.0
    base-4.15.1.0 base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu
    blaze-markup-0.8.2.8-6v8b9MTZTaSH16HPjvW1LE bytestring-0.10.12.1
    call-stack-0.4.0-AF4gWC5rZiPGBfZc4bnMry
    cassava-0.5.3.0-DaeORGwa1jTJG3fJgGTNJD
    cassava-megaparsec-2.0.4-7QKLw5P6qANDxTaSk9npzH
    cmdargs-0.10.22-LMGehiIpWZC4X4EZqKH5Yu
    colour-2.3.6-EuYv2zipv8X3m9Cp1zQHEC containers-0.6.4.1
    data-default-0.7.1.1-8E5NGoO1gLxEpVTFDWBmYU deepseq-1.4.5.0
    directory-1.3.6.2 doclayout-0.4.0.1-GzkdJ3DlTkxAzMbIxH5s4M
    extra-1.7.13-HYX6gpOPDmAIHqUj1ljVuZ
    file-embed-0.0.15.0-FF5xUPWKaB3GI64c6hgPnn filepath-1.4.2.1
    hashtables-1.3.1-45c5RsW03fJCUDS4qzuITr
    megaparsec-9.3.1-LmiWZGXQazp1nnuwCBnmcX
    microlens-0.4.13.1-AoR6D5midYZB5ErWoiySs4
    microlens-th-0.4.3.13-2F8uJinYM5B66CBFDh33gA mtl-2.2.2
    pager-0.1.1.0-G1lrlgXYTj1Ky89kETlEbe
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB
    pretty-simple-4.1.2.0-3r5QcyFmBmL1q6KjmO86Iy
    regex-tdfa-1.3.2.2-9R5AJXd71FKmHTeEzzCL9
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    tabular-0.2.2.8-3mznlUNrnmF8EH6LDY9YkX
    tasty-1.4.3-F5jS0TcPgL077vxy1alhqa
    tasty-hunit-0.10.0.3-A83AgJq5l3J3trj34rGoWt
    template-haskell-2.17.0.0 text-1.2.5.0
    text-ansi-0.2.1.1-AAgwmJIiNvK5moT80bMV20 time-1.9.3
    timeit-2.0-13BYXbUXu2MJzbvDZuPEww transformers-0.5.6.2
    uglymemo-0.1.0.1-K7bsHpbExS57pk9A4akql7
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    utf8-string-1.0.2-519AraujIYSLY3i7TJuoqO

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

