#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-G1uTykQLYJgGDytFeGNwrT
key:                  hOpenPGP-2.9.8-G1uTykQLYJgGDytFeGNwrT
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  d1ad6a6de15775300956301f9ad11968
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-G1uTykQLYJgGDytFeGNwrT
depends:
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    asn1-encoding-0.9.6-1Z4gQw1tzUE2BT1xNwBCfI
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base16-bytestring-1.0.2.0-9D56NZe6o4J55Lq4iVKJS0
    bifunctors-5.5.15-3KMbabBcAMBDp1F0CEHRh3 binary-0.8.8.0
    binary-conduit-1.3.1-ABrfMQXmVtoBCiRMt2fk0t bytestring-0.10.12.1
    bz2-1.0.1.0-COoaAZPxbcmB6l7YFrsBIM
    conduit-1.3.5-Jq81tBeR2eG6Vm9Wfmg9Au
    conduit-extra-1.3.6-81BNaX6jVC8HfEWFG32czK containers-0.6.4.1
    crypto-cipher-types-0.0.9-KWjc9vfsgOg2zA2BroK1gz
    cryptonite-0.30-A2WcUXrCplbraDFo3HWcX
    errors-2.3.0-F4rUJSCR8jkHhnELGOml9T
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    incremental-parser-0.5.0.5-FYcUyh81TUMIdz7ca6IrI6
    ixset-typed-0.5.1.0-9p5W0skghgLDAtBamtczVQ
    lens-5.2.2-4uj1AepANiF2ook39zjsmk
    memory-0.17.0-Ba80JGdi30PBt5EgUiQ1Tu
    monad-loops-0.4.3-C4VZ1LczQKA9hVl8DS9fX
    nettle-0.3.0-JUk9idt8Zv29RmwndpcF26
    network-uri-2.6.4.2-18lVeOrHqdkDTTcK9hqBly
    openpgp-asciiarmor-0.1.2-3ApAnsKulDrABPrdJhWRR
    prettyprinter-1.7.1-9bwAyMlaUSyJVG7FMXWGKT
    resourcet-1.2.6-AavQnD5kc82Iq3gAOb9Jer
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf text-1.2.5.0 time-1.9.3
    time-locale-compat-0.1.1.5-1snbmhWP0619voIlJd9qOd
    transformers-0.5.6.2 unliftio-core-0.2.1.0-AJ3ipHGgln87h2Y2hfrpJj
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    zlib-0.6.3.0-5MlrrAbgjA8AXbUw8xgJze

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

