#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslogger
version:              1.3.1.0
visibility:           public
id:                   hslogger-1.3.1.0-8EmNMt8WvrC4dQ5b2HGLzn
key:                  hslogger-1.3.1.0-8EmNMt8WvrC4dQ5b2HGLzn
license:              BSD-3-Clause
copyright:
    Copyright (c) 2004-2018 John Goerzen
    , (c) 2019      Herbert Valerio Riedel

maintainer:           hvr@gnu.org
author:               John Goerzen
homepage:             https://github.com/hvr/hslogger/wiki
synopsis:             Versatile logging framework
description:
    @hslogger@ is a logging framework for Haskell, roughly similar
    to [Python'\''s logging module](https://docs.python.org/2/library/logging.html).

    @hslogger@ lets each log message have a priority and source be associated
    with it.  The programmer can then define global handlers that route
    or filter messages based on the priority and source.  @hslogger@ also
    has a [Syslog](https://tools.ietf.org/html/rfc5424) handler built in.

category:             Interfaces
abi:                  181937264e6ce3ebba14cf81fae3660c
exposed:              True
exposed-modules:
    System.Log System.Log.Formatter System.Log.Handler
    System.Log.Handler.Growl System.Log.Handler.Log4jXML
    System.Log.Handler.Simple System.Log.Handler.Syslog
    System.Log.Logger

hidden-modules:       UTF8
import-dirs:          /usr/lib/ghc-9.0.2/site-local/hslogger-1.3.1.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hslogger-1.3.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslogger
hs-libraries:         HShslogger-1.3.1.0-8EmNMt8WvrC4dQ5b2HGLzn
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    network-bsd-2.8.1.0-DbFy0bWqLWFEQR6BoULsae
    old-locale-1.0.0.7-B94o3sNLYrV8oE3WO2rqHh time-1.9.3 unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-hslogger/html/hslogger.haddock
haddock-html:         /usr/share/doc/haskell-hslogger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

