#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslua
version:              2.3.0
visibility:           public
id:                   hslua-2.3.0-9irci7drnczHDqCJwY3mIu
key:                  hslua-2.3.0-9irci7drnczHDqCJwY3mIu
license:              MIT
copyright:
    © 2007–2012 Gracjan Polak;
    © 2012–2016 Ömer Sinan Ağacan;
    © 2017-2023 Albert Krewinkel

maintainer:           tarleb@hslua.org
author:               Albert Krewinkel, Gracjan Polak, Ömer Sinan Ağacan
homepage:             https://hslua.org/
synopsis:             Bindings to Lua, an embeddable scripting language
description:
    HsLua provides wrappers and helpers
    to bridge Haskell and <https://www.lua.org/ Lua>.

    It builds upon the /lua/ package, which allows to bundle
    a Lua interpreter with a Haskell program.

    Example programs are can be found in the @hslua-examples@
    subdir of the project
    <https://github.com/hslua/hslua repository>.

category:             Foreign
abi:                  33970278e9292ff00d3ef258899d86ff
exposed:              True
exposed-modules:
    HsLua,
    HsLua.Aeson from hslua-aeson-2.3.0-8FExBeOLDhOHfDmMhZkCop:HsLua.Aeson,
    HsLua.Class.Exposable from hslua-classes-2.3.0-36T1lENs3A4DZspSLUtTly:HsLua.Class.Exposable,
    HsLua.Class.Invokable from hslua-classes-2.3.0-36T1lENs3A4DZspSLUtTly:HsLua.Class.Invokable,
    HsLua.Class.Peekable from hslua-classes-2.3.0-36T1lENs3A4DZspSLUtTly:HsLua.Class.Peekable,
    HsLua.Class.Pushable from hslua-classes-2.3.0-36T1lENs3A4DZspSLUtTly:HsLua.Class.Pushable,
    HsLua.Class.Util from hslua-classes-2.3.0-36T1lENs3A4DZspSLUtTly:HsLua.Class.Util,
    HsLua.Core from hslua-core-2.3.1-1NRrmcM3Go44PdfkVxS9GC:HsLua.Core,
    HsLua.Core.Error from hslua-core-2.3.1-1NRrmcM3Go44PdfkVxS9GC:HsLua.Core.Error,
    HsLua.Core.Types from hslua-core-2.3.1-1NRrmcM3Go44PdfkVxS9GC:HsLua.Core.Types,
    HsLua.Core.Utf8 from hslua-core-2.3.1-1NRrmcM3Go44PdfkVxS9GC:HsLua.Core.Utf8,
    HsLua.Marshalling from hslua-marshalling-2.3.0-KIxjtNP1RK0BjOBkmH0bkh:HsLua.Marshalling,
    HsLua.ObjectOrientation from hslua-objectorientation-2.3.0-8OqLPzfamC029chB7r3bNz:HsLua.ObjectOrientation,
    HsLua.Packaging from hslua-packaging-2.3.0-BNMkP46M4AzK9tW3bPLi1G:HsLua.Packaging,
    HsLua.Packaging.Function from hslua-packaging-2.3.0-BNMkP46M4AzK9tW3bPLi1G:HsLua.Packaging.Function,
    HsLua.Packaging.Module from hslua-packaging-2.3.0-BNMkP46M4AzK9tW3bPLi1G:HsLua.Packaging.Module,
    HsLua.Packaging.Rendering from hslua-packaging-2.3.0-BNMkP46M4AzK9tW3bPLi1G:HsLua.Packaging.Rendering,
    HsLua.Typing from hslua-typing-0.1.0-EYLKSAbDC9k4NmizdMabv1:HsLua.Typing,
    HsLua.Util

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hslua-2.3.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hslua-2.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua
hs-libraries:         HShslua-2.3.0-9irci7drnczHDqCJwY3mIu
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    exceptions-0.10.4 hslua-aeson-2.3.0-8FExBeOLDhOHfDmMhZkCop
    hslua-classes-2.3.0-36T1lENs3A4DZspSLUtTly
    hslua-core-2.3.1-1NRrmcM3Go44PdfkVxS9GC
    hslua-marshalling-2.3.0-KIxjtNP1RK0BjOBkmH0bkh
    hslua-objectorientation-2.3.0-8OqLPzfamC029chB7r3bNz
    hslua-packaging-2.3.0-BNMkP46M4AzK9tW3bPLi1G
    hslua-typing-0.1.0-EYLKSAbDC9k4NmizdMabv1 mtl-2.2.2 text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-hslua/html/hslua.haddock
haddock-html:         /usr/share/doc/haskell-hslua/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

