#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HsYAML-aeson
version:              0.2.0.1
visibility:           public
id:                   HsYAML-aeson-0.2.0.1-Eep1zHmKpGcLFtZuH3sBRu
key:                  HsYAML-aeson-0.2.0.1-Eep1zHmKpGcLFtZuH3sBRu
license:              GPL-2.0-or-later
copyright:            2018-2019 Herbert Valerio Riedel
maintainer:           hvr@gnu.org, Andreas Abel
author:               Herbert Valerio Riedel
synopsis:             JSON to YAML Adapter
description:
    The [YAML 1.2](https://yaml.org/spec/1.2/spec.html) format provides
    a much richer data-model and feature-set
    than the [JavaScript Object Notation (JSON)](https://tools.ietf.org/html/rfc7159) format.
    However, sometimes it'\''s desirable to ignore the extra capabilities
    and treat YAML as if it was merely a more convenient markup format
    for humans to write JSON data. To this end this module provides a
    compatibility layer atop [HsYAML](https://hackage.haskell.org/package/HsYAML)
    which allows decoding YAML documents in the more limited JSON data-model while also providing
    convenience by reusing [aeson](https://hackage.haskell.org/package/aeson)'\''s
    '\''FromJSON'\'' instances for decoding the YAML data into native Haskell data types.

category:             Text, Codec, Web, JSON, YAML
abi:                  f7d6c1f7faf1d3ac59b6bdb2e293f5c0
exposed:              True
exposed-modules:      Data.YAML.Aeson
import-dirs:          /usr/lib/ghc-9.0.2/site-local/HsYAML-aeson-0.2.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/HsYAML-aeson-0.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hsyaml-aeson
hs-libraries:         HSHsYAML-aeson-0.2.0.1-Eep1zHmKpGcLFtZuH3sBRu
depends:
    HsYAML-0.2.1.1-C3zC5VXXyx5A8HOTbXrF0p
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4 base-4.15.1.0
    bytestring-0.10.12.1 containers-0.6.4.1 mtl-2.2.2
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR text-1.2.5.0
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:
    /usr/share/doc/haskell-hsyaml-aeson/html/HsYAML-aeson.haddock

haddock-html:         /usr/share/doc/haskell-hsyaml-aeson/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

