#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HTF
version:              0.15.0.1
visibility:           public
id:                   HTF-0.15.0.1-KgxaaxXlBlQgIudYHzxo8
key:                  HTF-0.15.0.1-KgxaaxXlBlQgIudYHzxo8
license:              LGPL-2.1-only
copyright:            (c) 2005-2023 Stefan Wehr
maintainer:           Stefan Wehr
author:               Stefan Wehr
stability:            Beta
homepage:             https://github.com/skogsbaer/HTF/
synopsis:             The Haskell Test Framework
description:
    The Haskell Test Framework (/HTF/ for short) lets you define and organize unit tests,
    QuickCheck properties,
    and black box tests in an
    easy and convenient way. HTF uses a custom preprocessor that collects
    test definitions automatically.

    HTF produces highly readable output
    for failing test cases: it provides exact file name and line number
    information,
    it colors and pretty prints expected and
    actual results, and it displays a diff highlighting the mismatching parts.

    The documentation of the "Test.Framework.Tutorial" module
    provides a tutorial for HTF. The /sample/ directory in
    the HTF repo provides a good starting point for
    a project using HTF.

category:             Testing
abi:                  255bb67cc40d6672ee14d8f01e78d37c
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.AssertM Test.Framework.BlackBoxTest
    Test.Framework.HUnitWrapper Test.Framework.History
    Test.Framework.JsonOutput Test.Framework.Location
    Test.Framework.Preprocessor Test.Framework.Pretty
    Test.Framework.PrettyHaskell Test.Framework.QuickCheckWrapper
    Test.Framework.TestInterface Test.Framework.TestManager
    Test.Framework.TestTypes Test.Framework.ThreadPool
    Test.Framework.Tutorial Test.Framework.XmlOutput

hidden-modules:
    Paths_HTF Test.Framework.CmdlineOptions Test.Framework.Colors
    Test.Framework.Diff Test.Framework.Process
    Test.Framework.TestReporter Test.Framework.Utils

import-dirs:          /usr/lib/ghc-9.0.2/site-local/HTF-0.15.0.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/HTF-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-htf
hs-libraries:         HSHTF-0.15.0.1-KgxaaxXlBlQgIudYHzxo8
depends:
    Diff-0.4.1-GdxJqSCBWVSImKhqghLkQt
    HUnit-1.6.2.0-JGxgr0O3qDr2sR1C0CRfuz
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4 array-0.5.4.0 base-4.15.1.0
    base64-bytestring-1.2.1.0-D7qbdpqh7ZAHvyipCqb2En
    bytestring-0.10.12.1 containers-0.6.4.1
    cpphs-1.20.9.1-1jAFiSyqcHj3RbgQIQP02q directory-1.3.6.2
    haskell-src-1.0.4-DDQyeF0j6Hx16UheZszQyV
    lifted-base-0.2.3.12-BiJRsPA9EvQGhEhORMP1Pf
    monad-control-1.0.3.1-35h1aVdsL57202S8tnbNU9 mtl-2.2.2
    old-time-1.1.0.3-B4Ro2AUl5kn1VzPHPQkaoe pretty-1.1.3.6
    process-1.6.13.2 random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    regex-compat-0.95.2.1-itFB4fXPjn9OuocZGgbix text-1.2.5.0 time-1.9.3
    unix-2.7.2.2 vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    xmlgen-0.6.2.2-IyR70OdvnuFa338MGqnKV

haddock-interfaces:   /usr/share/doc/haskell-htf/html/HTF.haddock
haddock-html:         /usr/share/doc/haskell-htf/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

