#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 http2
version:              3.0.3
visibility:           public
id:                   http2-3.0.3-9eA9Kh0I08hAtXz9iaASN8
key:                  http2-3.0.3-9eA9Kh0I08hAtXz9iaASN8
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Kazu Yamamoto <kazu@iij.ad.jp>
homepage:             https://github.com/kazu-yamamoto/http2
synopsis:             HTTP/2 library
description:
    HTTP/2 library including frames, priority queues, HPACK, client and server.

category:             Network
abi:                  7ac963cc8ac2a37fdc328725f3dd5744
exposed:              True
exposed-modules:
    Network.HPACK Network.HPACK.Internal Network.HPACK.Table
    Network.HPACK.Token Network.HTTP2 Network.HTTP2.Client
    Network.HTTP2.Client.Internal Network.HTTP2.Frame
    Network.HTTP2.Internal Network.HTTP2.Priority
    Network.HTTP2.Priority.Internal Network.HTTP2.Server
    Network.HTTP2.Server.Internal

hidden-modules:
    Imports Network.HPACK.Builder Network.HTTP2.Client.Types
    Network.HTTP2.Client.Run Network.HPACK.HeaderBlock
    Network.HPACK.HeaderBlock.Decode Network.HPACK.HeaderBlock.Encode
    Network.HPACK.HeaderBlock.Integer Network.HPACK.Huffman
    Network.HPACK.Huffman.Bit Network.HPACK.Huffman.ByteString
    Network.HPACK.Huffman.Decode Network.HPACK.Huffman.Encode
    Network.HPACK.Huffman.Params Network.HPACK.Huffman.Table
    Network.HPACK.Huffman.Tree Network.HPACK.Table.Dynamic
    Network.HPACK.Table.Entry Network.HPACK.Table.RevIndex
    Network.HPACK.Table.Static Network.HPACK.Types Network.HTTP2.Arch
    Network.HTTP2.Arch.Cache Network.HTTP2.Arch.Config
    Network.HTTP2.Arch.Context Network.HTTP2.Arch.EncodeFrame
    Network.HTTP2.Arch.File Network.HTTP2.Arch.HPACK
    Network.HTTP2.Arch.Manager Network.HTTP2.Arch.Queue
    Network.HTTP2.Arch.Rate Network.HTTP2.Arch.ReadN
    Network.HTTP2.Arch.Receiver Network.HTTP2.Arch.Sender
    Network.HTTP2.Arch.Status Network.HTTP2.Arch.Stream
    Network.HTTP2.Arch.Types Network.HTTP2.Frame.Decode
    Network.HTTP2.Frame.Encode Network.HTTP2.Frame.Types
    Network.HTTP2.Priority.PSQ Network.HTTP2.Priority.Queue
    Network.HTTP2.Server.Run Network.HTTP2.Server.Types
    Network.HTTP2.Server.Worker

import-dirs:          /usr/lib/ghc-9.0.2/site-local/http2-3.0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/http2-3.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http2
hs-libraries:         HShttp2-3.0.3-9eA9Kh0I08hAtXz9iaASN8
depends:
    array-0.5.4.0 async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4 base-4.15.1.0
    bytestring-0.10.12.1 case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    containers-0.6.4.1 http-types-0.12.3-GFhxs6XVQ6bETbOR4vEFmW
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    network-byte-order-0.1.6-KZHTAGj3L6V48r5fDZziTH
    psqueues-0.2.7.3-AfhmY4zXhLw1txyXh9MWSt stm-2.5.0.0
    time-manager-0.0.1-9l95eJ7N7Q3GGwNYKZgFeM
    unix-time-0.4.10-7YOaCPS6dHg7Z3fr1g5ZiW

haddock-interfaces:   /usr/share/doc/haskell-http2/html/http2.haddock
haddock-html:         /usr/share/doc/haskell-http2/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

