#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hxt-regex-xmlschema
version:              9.2.0.7
visibility:           public
id:                   hxt-regex-xmlschema-9.2.0.7-D8wgSFW3JvRC757jFy9vhs
key:                  hxt-regex-xmlschema-9.2.0.7-D8wgSFW3JvRC757jFy9vhs
license:              MIT
copyright:            Copyright (c) 2010- Uwe Schmidt
maintainer:           Uwe Schmidt <uwe@fh-wedel.de>
author:               Uwe Schmidt
stability:            stable
homepage:
    http://www.haskell.org/haskellwiki/Regular_expressions_for_XML_Schema

synopsis:
    A regular expression library for W3C XML Schema regular expressions

description:
    This library supports full W3C XML Schema regular expressions
    inclusive all Unicode character sets and blocks.
    The complete grammar can be found under <http://www.w3.org/TR/xmlschema11-2/#regexs>.
    It is implemented by the technique of derivations of regular expressions.

    The W3C syntax is extended to support not only union of regular sets,
    but also intersection, set difference, exor.
    Matching of subexpressions is also supported.

    The library can be used for constricting lightweight scanners and tokenizers.
    It is a standalone library, no external regex libraries are used.

    Extensions in 9.2: The library does nor only support String'\''s, but also
    ByteString'\''s and Text in strict and lazy variants

category:             Text
abi:                  1991f548c818df6d37be7a1f82289d96
exposed:              True
exposed-modules:
    Text.Regex.Glob.Generic Text.Regex.Glob.Generic.RegexParser
    Text.Regex.Glob.String Text.Regex.XMLSchema.Generic
    Text.Regex.XMLSchema.Generic.Matching
    Text.Regex.XMLSchema.Generic.Regex
    Text.Regex.XMLSchema.Generic.RegexParser
    Text.Regex.XMLSchema.Generic.StringLike Text.Regex.XMLSchema.String

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hxt-regex-xmlschema-9.2.0.7
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hxt-regex-xmlschema-9.2.0.7
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/x86_64-linux-ghc-9.0.2/hxt-regex-xmlschema-9.2.0.7

hs-libraries:         HShxt-regex-xmlschema-9.2.0.7-D8wgSFW3JvRC757jFy9vhs
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    hxt-charproperties-9.5.0.0-BUzcmi88CMq3OISKIjEA5L parsec-3.1.14.0
    text-1.2.5.0

haddock-interfaces:
    /usr/share/doc/haskell-hxt-regex-xmlschema/html/hxt-regex-xmlschema.haddock

haddock-html:         /usr/share/doc/haskell-hxt-regex-xmlschema/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

