#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 incremental-parser
version:              0.5.0.5
visibility:           public
id:                   incremental-parser-0.5.0.5-FYcUyh81TUMIdz7ca6IrI6
key:                  incremental-parser-0.5.0.5-FYcUyh81TUMIdz7ca6IrI6
license:              GPL-3.0-only
copyright:            (c) 2011-2023 Mario Blazevic
maintainer:           blamario@yahoo.com
author:               Mario Blazevic
homepage:             https://github.com/blamario/incremental-parser
synopsis:
    Generic parser library capable of providing partial results from partial input.

description:
    This package defines yet another parser combinator library. This one is implemented using the concept of Brzozowski
    derivatives, tweaked and optimized to work with any monoidal input type. Lists, ByteString, and Text are supported out
    of the box, as well as any other data type for which the monoid-subclasses package defines instances. If the parser
    result is also a monoid, its chunks can be extracted incrementally, before the complete input is parsed.

category:             Parsing
abi:                  92ffcb6efbfcdf80370c913b78b7f85a
exposed:              True
exposed-modules:
    Control.Applicative.Monoid Text.ParserCombinators.Incremental
    Text.ParserCombinators.Incremental.LeftBiasedLocal
    Text.ParserCombinators.Incremental.Symmetric

import-dirs:          /usr/lib/ghc-9.0.2/site-local/incremental-parser-0.5.0.5
library-dirs:         /usr/lib/ghc-9.0.2/site-local/incremental-parser-0.5.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-incremental-parser
hs-libraries:         HSincremental-parser-0.5.0.5-FYcUyh81TUMIdz7ca6IrI6
depends:
    base-4.15.1.0 input-parsers-0.3.0.1-2QYJHidrW6ELEC3ieOQUwV
    monoid-subclasses-1.2.4-1cQtXGTCQ0VGjNiwvVojGO
    parsers-0.12.11-4GlGGJopDxbEBWyVDgDjI4
    rank2classes-1.5.2-AezPZIKSrKJDRbM9IP3xXD transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-incremental-parser/html/incremental-parser.haddock

haddock-html:         /usr/share/doc/haskell-incremental-parser/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

