#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 JuicyPixels
version:              3.3.8
visibility:           public
id:                   JuicyPixels-3.3.8-F8bHCdJrIIDDR6l4PKjzmn
key:                  JuicyPixels-3.3.8-F8bHCdJrIIDDR6l4PKjzmn
license:              BSD-3-Clause
maintainer:           vincent.berthoux@gmail.com
author:               Vincent Berthoux
stability:            Stable
homepage:             https://github.com/Twinside/Juicy.Pixels
synopsis:
    Picture loading/serialization (in png, jpeg, bitmap, gif, tga, tiff and radiance)

description:
    <<data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMAAAADABAMAAACg8nE0AAAAElBMVEUAAABJqDSTWEL/qyb///8AAABH/1GTAAAAAXRSTlMAQObYZgAAAN5JREFUeF7s1sEJgFAQxFBbsAV72v5bEVYWPwT/XDxmCsi7zvHXavYREBDI3XP2GgICqBBYuwIC+/rVayPUAyAg0HvIXBcQoDFDGnUBgWQQ2Bx3AYFaRoBpAQHWb3bt2ARgGAiCYFFuwf3X5HA/McgGJWI2FdykCv4aBYzmKwDwvl6NVmUAAK2vlwEALK7fo88GANB6HQsAAAAAAAAA7P94AQCzswEAAAAAAAAAAAAAAAAAAICzh4UAO4zWAYBfRutHA4Bn5C69JhowAMGoBaMWDG0wCkbBKBgFo2AUAACPmegUST/IJAAAAABJRU5ErkJggg==>>

    This library can load and store images in PNG,Bitmap, Jpeg, Radiance, Tiff and Gif images.

category:             Codec, Graphics, Image
abi:                  0513f772e099bcab16cc8ddc4feba831
exposed:              True
exposed-modules:
    Codec.Picture Codec.Picture.Bitmap Codec.Picture.ColorQuant
    Codec.Picture.Gif Codec.Picture.Gif.Internal.LZW
    Codec.Picture.Gif.Internal.LZWEncoding Codec.Picture.HDR
    Codec.Picture.Jpg Codec.Picture.Jpg.Internal.Common
    Codec.Picture.Jpg.Internal.DefaultTable
    Codec.Picture.Jpg.Internal.FastDct
    Codec.Picture.Jpg.Internal.FastIdct
    Codec.Picture.Jpg.Internal.Metadata
    Codec.Picture.Jpg.Internal.Progressive
    Codec.Picture.Jpg.Internal.Types Codec.Picture.Metadata
    Codec.Picture.Metadata.Exif Codec.Picture.Png
    Codec.Picture.Png.Internal.Export
    Codec.Picture.Png.Internal.Metadata Codec.Picture.Png.Internal.Type
    Codec.Picture.Saving Codec.Picture.Tga Codec.Picture.Tiff
    Codec.Picture.Tiff.Internal.Metadata
    Codec.Picture.Tiff.Internal.Types Codec.Picture.Types

hidden-modules:
    Codec.Picture.BitWriter Codec.Picture.InternalHelper
    Codec.Picture.VectorByteConversion

import-dirs:          /usr/lib/ghc-9.0.2/site-local/JuicyPixels-3.3.8
library-dirs:         /usr/lib/ghc-9.0.2/site-local/JuicyPixels-3.3.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-juicypixels
hs-libraries:         HSJuicyPixels-3.3.8-F8bHCdJrIIDDR6l4PKjzmn
include-dirs:         /usr/lib/ghc-9.0.2/site-local/JuicyPixels-3.3.8/include
depends:
    base-4.15.1.0 binary-0.8.8.0 bytestring-0.10.12.1
    containers-0.6.4.1 deepseq-1.4.5.0 mtl-2.2.2
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q transformers-0.5.6.2
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh
    zlib-0.6.3.0-5MlrrAbgjA8AXbUw8xgJze

haddock-interfaces:   /usr/share/doc/haskell-juicypixels/html/JuicyPixels.haddock
haddock-html:         /usr/share/doc/haskell-juicypixels/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

