#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lattices
version:              2.1
visibility:           public
id:                   lattices-2.1-L7M88O17elVEhEHjEr1iQS
key:                  lattices-2.1-L7M88O17elVEhEHjEr1iQS
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  417b3a1958ecb52cebc2bc8964ec5c95
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Unicode
    Algebra.Lattice.Wide Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-9.0.2/site-local/lattices-2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lattices-2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lattices
hs-libraries:         HSlattices-2.1-L7M88O17elVEhEHjEr1iQS
depends:
    QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4 base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu containers-0.6.4.1
    deepseq-1.4.5.0 ghc-prim-0.7.0
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    integer-logarithms-1.0.3.1-5kS6jNbEsIJGKjr4VAkZqE
    semigroupoids-5.3.7-KA0YT7sGVtk8p8u4maj8I2
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf transformers-0.5.6.2
    universe-base-1.1.3.1-EGGaoKbtfkjBEOFM7P5P0T
    universe-reverse-instances-1.1.1-B8n20Tnt2TjLVXwqMsJpqO
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

