#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lens
version:              5.2.2
visibility:           public
id:                   lens-5.2.2-4uj1AepANiF2ook39zjsmk
key:                  lens-5.2.2-4uj1AepANiF2ook39zjsmk
license:              BSD-2-Clause
copyright:            Copyright (C) 2012-2016 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/lens/
synopsis:             Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.

    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.

    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.

    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.

    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.

    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.

    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.

    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.

    /Lenses, Folds and Traversals/

    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:


    <<http://i.imgur.com/ALlbPRa.png>>

    <https://raw.githubusercontent.com/ekmett/lens/master/images/Hierarchy.png (Local Copy)>

    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.

    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).

    For instance:

    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.

    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.

    /Minimizing Dependencies/

    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.

    /e.g./ for a data type:

    > data Foo a = Foo Int Int a

    You can define lenses such as

    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)

    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)

    without the need to use any type that isn'\''t already defined in the @Prelude@.

    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':

    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c

    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).

category:             Data, Lenses, Generics
abi:                  02aa56ba28788d89750d53f9e588c367
exposed:              True
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.CTypes
    Control.Lens.Internal.Context Control.Lens.Internal.Deque
    Control.Lens.Internal.Exception Control.Lens.Internal.FieldTH
    Control.Lens.Internal.Fold Control.Lens.Internal.Getter
    Control.Lens.Internal.Indexed Control.Lens.Internal.Instances
    Control.Lens.Internal.Iso Control.Lens.Internal.Level
    Control.Lens.Internal.List Control.Lens.Internal.Magma
    Control.Lens.Internal.Prism Control.Lens.Internal.PrismTH
    Control.Lens.Internal.Profunctor Control.Lens.Internal.Review
    Control.Lens.Internal.Setter Control.Lens.Internal.TH
    Control.Lens.Internal.Zoom Control.Lens.Iso Control.Lens.Lens
    Control.Lens.Level Control.Lens.Operators Control.Lens.Plated
    Control.Lens.Prism Control.Lens.Profunctor Control.Lens.Reified
    Control.Lens.Review Control.Lens.Setter Control.Lens.TH
    Control.Lens.Traversal Control.Lens.Tuple Control.Lens.Type
    Control.Lens.Unsound Control.Lens.Wrapped Control.Lens.Zoom
    Control.Monad.Error.Lens Control.Parallel.Strategies.Lens
    Control.Seq.Lens Data.Array.Lens Data.Bits.Lens
    Data.ByteString.Lazy.Lens Data.ByteString.Lens
    Data.ByteString.Strict.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lazy.Lens
    Data.Text.Lens Data.Text.Strict.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Generic.Lens Data.Vector.Lens
    GHC.Generics.Lens Language.Haskell.TH.Lens Numeric.Lens
    Numeric.Natural.Lens System.Exit.Lens System.FilePath.Lens
    System.IO.Error.Lens

hidden-modules:       Control.Lens.Internal.Prelude
import-dirs:          /usr/lib/ghc-9.0.2/site-local/lens-5.2.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lens-5.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lens
hs-libraries:         HSlens-5.2.2-4uj1AepANiF2ook39zjsmk
depends:
    array-0.5.4.0 assoc-1.0.2-2XMofMeCFM4GQHAP0AijVK base-4.15.1.0
    base-orphans-0.8.7-LhKj0z9LMht22T0DHRHyFW
    bifunctors-5.5.15-3KMbabBcAMBDp1F0CEHRh3 bytestring-0.10.12.1
    call-stack-0.4.0-AF4gWC5rZiPGBfZc4bnMry
    comonad-5.0.8-4z7AihQ42OKAJi2EQgp02u containers-0.6.4.1
    contravariant-1.5.5-FtJyCLyWfutGN2UWoJs8qd
    distributive-0.6.2.1-JglHNXXzwPGIzyZMyl4KIx exceptions-0.10.4
    filepath-1.4.2.1 free-5.1.10-JIdA28qKKvuIGxHjXb7ZXe ghc-prim-0.7.0
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW
    indexed-traversable-0.1.2.1-JwIQVWOpW67GVSWDdLo884
    indexed-traversable-instances-0.1.1.2-ITg9ZgLh5kL5mJNTLzSwI3
    kan-extensions-5.2.5-12K3DFSEkkRCSlgJd7xxJe mtl-2.2.2
    parallel-3.2.2.0-D2aleEa2VnPBr164BdKnms
    profunctors-5.6.2-5HBtTiYfVT6KsCqpwzceco
    reflection-2.1.7-Hmid6ateHjp6DWcS7c80KZ
    semigroupoids-5.3.7-KA0YT7sGVtk8p8u4maj8I2
    strict-0.4.0.1-DqIvrYJvHoWHqER1V0TQ0H
    tagged-0.8.7-8MQxDldL1qw9fJF5LZxnpf template-haskell-2.17.0.0
    text-1.2.5.0 th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp
    these-1.1.1.1-Co8qfzI8wtgJaT0RN5FqXo transformers-0.5.6.2
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html:         /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

