#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-test
version:              0.14.0.2
visibility:           public
id:                   lsp-test-0.14.0.2-FA6X4rUr9RKKyTiLWrLdYi
key:                  lsp-test-0.14.0.2-FA6X4rUr9RKKyTiLWrLdYi
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  c4c2ba477ebcf20abfbcc3b5ff1105ee
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.4.0.1-8WuPiY8RaW5I4Oik923uPu:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-8WuPiY8RaW5I4Oik923uPu:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.0.2/site-local/lsp-test-0.14.0.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/lsp-test-0.14.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test0.14.0
hs-libraries:         HSlsp-test-0.14.0.2-FA6X4rUr9RKKyTiLWrLdYi
depends:
    Diff-0.4.1-GdxJqSCBWVSImKhqghLkQt
    Glob-0.10.2-3nVoBiOJijA9OiBj5S4ual
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    aeson-pretty-0.8.9-5lTV2yokao3rqi6vQJbJu
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4 base-4.15.1.0
    bytestring-0.10.12.1 conduit-1.3.5-Jq81tBeR2eG6Vm9Wfmg9Au
    conduit-parse-0.2.1.1-JMrmohiUcx6F9m1rcJT9vn containers-0.6.4.1
    data-default-0.7.1.1-8E5NGoO1gLxEpVTFDWBmYU directory-1.3.6.2
    filepath-1.4.2.1 lens-5.2.2-4uj1AepANiF2ook39zjsmk
    lsp-types-1.4.0.1-8WuPiY8RaW5I4Oik923uPu mtl-2.2.2
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB process-1.6.13.2
    some-1.0.5-2CCxSGFRQ8m3FjAx9nXmXm text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz

haddock-interfaces:   /usr/share/doc/haskell-lsp-test0.14.0/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test0.14.0/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

