#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 monoid-subclasses
version:              1.2.4
visibility:           public
id:                   monoid-subclasses-1.2.4-1cQtXGTCQ0VGjNiwvVojGO
key:                  monoid-subclasses-1.2.4-1cQtXGTCQ0VGjNiwvVojGO
license:              BSD-3-Clause
copyright:            (c) 2013-2023 Mario Blažević
maintainer:           Mario Blažević <blamario@protonmail.com>
author:               Mario Blažević
homepage:             https://github.com/blamario/monoid-subclasses/
synopsis:             Subclasses of Monoid
description:
    A hierarchy of subclasses of '\''Monoid'\'' together with their instances for all data structures from base, containers, and
    text packages.

category:             Data, Algebra, Text
abi:                  859ad966fa051042eeb12d132d57223f
exposed:              True
exposed-modules:
    Data.Monoid.Cancellative Data.Monoid.Factorial Data.Monoid.GCD
    Data.Monoid.Instances.ByteString.UTF8
    Data.Monoid.Instances.CharVector Data.Monoid.Instances.Concat
    Data.Monoid.Instances.Measured Data.Monoid.Instances.Positioned
    Data.Monoid.Instances.PrefixMemory Data.Monoid.Instances.Stateful
    Data.Monoid.LCM Data.Monoid.Monus Data.Monoid.Null
    Data.Monoid.Textual Data.Semigroup.Cancellative
    Data.Semigroup.Factorial

import-dirs:          /usr/lib/ghc-9.0.2/site-local/monoid-subclasses-1.2.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/monoid-subclasses-1.2.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-monoid-subclasses
hs-libraries:         HSmonoid-subclasses-1.2.4-1cQtXGTCQ0VGjNiwvVojGO
depends:
    base-4.15.1.0 bytestring-0.10.12.1
    commutative-semigroups-0.1.0.1-IUFcGU4VCJzC1jgHpr3UMz
    containers-0.6.4.1 primes-0.2.1.0-40IDvqpKPw7IteoZuUfZEg
    text-1.2.5.0 vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:
    /usr/share/doc/haskell-monoid-subclasses/html/monoid-subclasses.haddock

haddock-html:         /usr/share/doc/haskell-monoid-subclasses/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

