#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mueval
version:              0.9.3
visibility:           public
id:                   mueval-0.9.3-8VteQspeaYiGrB57sAGVjG
key:                  mueval-0.9.3-8VteQspeaYiGrB57sAGVjG
license:              BSD-3-Clause
maintainer:           Gwern <gwern@gwern.net>
author:               Gwern
homepage:             https://github.com/gwern/mueval
synopsis:             Safely evaluate pure Haskell expressions
description:
    Mueval is a Haskell interpreter. It
    uses the GHC API to evaluate arbitrary Haskell expressions.
    Importantly, mueval takes many precautions to defang and avoid \"evil\"
    code.  It uses resource limits, whitelisted modules and Safe Haskell,
    special Show instances for IO, threads, processes, and changes of directory
    to sandbox the Haskell code.

    It is, in short, intended to be a standalone version of Lambdabot'\''s famous
    evaluation functionality. For examples and explanations, please see the README file.

    Mueval is POSIX-only.

category:             Development, Language
abi:                  0b0333e635abcebe3dc4d96e86e0bd4e
exposed:              True
exposed-modules:
    Mueval.ArgsParse Mueval.Context Mueval.Interpreter Mueval.Parallel
    Mueval.Resources

import-dirs:          /usr/lib/ghc-9.0.2/site-local/mueval-0.9.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/mueval-0.9.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mueval
hs-libraries:         HSmueval-0.9.3-8VteQspeaYiGrB57sAGVjG
depends:
    Cabal-3.4.1.0 QuickCheck-2.14.3-1OE8Tk6Cvw85tkUdApuCR4
    base-4.15.1.0 containers-0.6.4.1 directory-1.3.6.2
    extensible-exceptions-0.1.1.4-FO4Sw13oBkvBW8j4vnJTpA
    filepath-1.4.2.1 hint-0.9.0.6-4XHzgmCt90Z8XK6nnRMsUD mtl-2.2.2
    process-1.6.13.2 show-0.6-2li3fCfxM6EIDbDhNk4UDz
    simple-reflect-0.3.3-63UyWZBqImk9E4Nw4bto0L unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-mueval/html/mueval.haddock
haddock-html:         /usr/share/doc/haskell-mueval/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

