#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mwc-random
version:              0.15.0.2
visibility:           public
id:                   mwc-random-0.15.0.2-LcgFDXKxrBg3pQAS28VrYq
key:                  mwc-random-0.15.0.2-LcgFDXKxrBg3pQAS28VrYq
license:              BSD-3-Clause
copyright:            2009, 2010, 2011 Bryan O'\''Sullivan
maintainer:           Bryan O'\''Sullivan <bos@serpentine.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/bos/mwc-random
synopsis:             Fast, high quality pseudo random number generation
description:
    This package contains code for generating high quality random
    numbers that follow either a uniform or normal distribution.  The
    generated numbers are suitable for use in statistical applications.

    The uniform PRNG uses Marsaglia'\''s MWC256 (also known as MWC8222)
    multiply-with-carry generator, which has a period of 2^8222 and
    fares well in tests of randomness.  It is also extremely fast,
    between 2 and 3 times faster than the Mersenne Twister.

    Compared to the mersenne-random package, this package has a more
    convenient API, is faster, and supports more statistical
    distributions.

category:             Math, Statistics
abi:                  f85a796c46a62ef78229f1a4464a134b
exposed:              True
exposed-modules:
    System.Random.MWC System.Random.MWC.CondensedTable
    System.Random.MWC.Distributions System.Random.MWC.SeedSource

import-dirs:          /usr/lib/ghc-9.0.2/site-local/mwc-random-0.15.0.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/mwc-random-0.15.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mwc-random
hs-libraries:         HSmwc-random-0.15.0.2-LcgFDXKxrBg3pQAS28VrYq
depends:
    base-4.15.1.0 math-functions-0.3.4.2-4X5leqErMg2JXn1eW69G9r
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt time-1.9.3
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/haskell-mwc-random/html/mwc-random.haddock
haddock-html:         /usr/share/doc/haskell-mwc-random/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

