#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 z-pandoc-z-xml-light
version:              3.1.2
package-name:         pandoc
lib-name:             xml-light
id:                   pandoc-3.1.2-9VGLBxlt6wu6wNuuCBpqw-xml-light
key:                  pandoc-3.1.2-9VGLBxlt6wu6wNuuCBpqw-xml-light
license:              GPL-2.0-or-later
copyright:            (c) 2006-2022 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized extensively
    using templates, filters, and custom readers and writers
    written in Lua.

category:             Text
abi:                  17d70023e2dc603e0791abe88ece0c76
exposed-modules:
    Text.Pandoc.XML.Light Text.Pandoc.XML.Light.Output
    Text.Pandoc.XML.Light.Proc Text.Pandoc.XML.Light.Types

import-dirs:          /usr/lib/ghc-9.0.2/site-local/pandoc-3.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/pandoc-3.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.1.2-9VGLBxlt6wu6wNuuCBpqw-xml-light
depends:
    base-4.15.1.0 containers-0.6.4.1 text-1.2.5.0
    xml-1.3.14-6hlhhPBptprHwK7nsE7OzM
    xml-conduit-1.9.1.3-FXhjiZfXbw4LbDReANXEOS
    xml-types-0.3.8-5QCBKSWiifmEtQB2jlqHYu

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pandoc
version:              3.1.2
visibility:           public
id:                   pandoc-3.1.2-AIgJLY68Ybw9Dp2bKMkgrF
key:                  pandoc-3.1.2-AIgJLY68Ybw9Dp2bKMkgrF
license:              GPL-2.0-or-later
copyright:            (c) 2006-2022 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane <jgm@berkeley.edu>
stability:            alpha
homepage:             https://pandoc.org
synopsis:             Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another.  The formats it can handle include

    - light markup formats (many variants of Markdown,
    reStructuredText, AsciiDoc, Org-mode, Muse, Textile,
    txt2tags)
    - HTML formats (HTML 4 and 5)
    - Ebook formats (EPUB v2 and v3, FB2)
    - Documentation formats (GNU TexInfo, Haddock)
    - Roff formats (man, ms)
    - TeX formats (LaTeX, ConTeXt)
    - Typst
    - XML formats (DocBook 4 and 5, JATS, TEI Simple, OpenDocument)
    - Outline formats (OPML)
    - Bibliography formats (BibTeX, BibLaTeX, CSL JSON, CSL YAML,
    RIS)
    - Word processor formats (Docx, RTF, ODT)
    - Interactive notebook formats (Jupyter notebook ipynb)
    - Page layout formats (InDesign ICML)
    - Wiki markup formats (MediaWiki, DokuWiki, TikiWiki, TWiki,
    Vimwiki, XWiki, ZimWiki, Jira wiki, Creole)
    - Slide show formats (LaTeX Beamer, PowerPoint, Slidy,
    reveal.js, Slideous, S5, DZSlides)
    - Data formats (CSV and TSV tables)
    - PDF (via external programs such as pdflatex or wkhtmltopdf)

    Pandoc can convert mathematical content in documents
    between TeX, MathML, Word equations, roff eqn, typst,
    and plain text. It includes a powerful system for automatic
    citations and bibliographies, and it can be customized extensively
    using templates, filters, and custom readers and writers
    written in Lua.

category:             Text
abi:                  a3be4bfd574ce5df9d1ba03fc3971063
exposed:              True
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.Chunks
    Text.Pandoc.Citeproc Text.Pandoc.Class Text.Pandoc.Class.IO
    Text.Pandoc.Data Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Filter Text.Pandoc.Format
    Text.Pandoc.Highlighting Text.Pandoc.ImageSize Text.Pandoc.Logging
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Process
    Text.Pandoc.Readers Text.Pandoc.Readers.BibTeX
    Text.Pandoc.Readers.CSV Text.Pandoc.Readers.CommonMark
    Text.Pandoc.Readers.Creole Text.Pandoc.Readers.CslJson
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.DokuWiki Text.Pandoc.Readers.EPUB
    Text.Pandoc.Readers.EndNote Text.Pandoc.Readers.FB2
    Text.Pandoc.Readers.HTML Text.Pandoc.Readers.Haddock
    Text.Pandoc.Readers.Ipynb Text.Pandoc.Readers.JATS
    Text.Pandoc.Readers.Jira Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.Man Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.ODT
    Text.Pandoc.Readers.OPML Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RIS Text.Pandoc.Readers.RST
    Text.Pandoc.Readers.RTF Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.Scripting Text.Pandoc.SelfContained Text.Pandoc.Shared
    Text.Pandoc.Slides Text.Pandoc.Sources Text.Pandoc.Templates
    Text.Pandoc.Translations Text.Pandoc.Translations.Types
    Text.Pandoc.UTF8 Text.Pandoc.Version Text.Pandoc.Writers
    Text.Pandoc.Writers.AnnotatedTable Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.BibTeX Text.Pandoc.Writers.ChunkedHTML
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.CslJson Text.Pandoc.Writers.DocBook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.Ipynb
    Text.Pandoc.Writers.JATS Text.Pandoc.Writers.Jira
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.Typst Text.Pandoc.Writers.XWiki
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML

hidden-modules:
    Text.Pandoc.App.CommandLineOptions Text.Pandoc.App.Input
    Text.Pandoc.App.Opt Text.Pandoc.App.OutputSettings
    Text.Pandoc.Class.CommonState Text.Pandoc.Class.PandocMonad
    Text.Pandoc.Class.PandocIO Text.Pandoc.Class.PandocPure
    Text.Pandoc.Class.Sandbox Text.Pandoc.Filter.Environment
    Text.Pandoc.Filter.JSON Text.Pandoc.Parsing.Capabilities
    Text.Pandoc.Parsing.Citations Text.Pandoc.Parsing.General
    Text.Pandoc.Parsing.GridTable Text.Pandoc.Parsing.Lists
    Text.Pandoc.Parsing.Math Text.Pandoc.Parsing.Smart
    Text.Pandoc.Parsing.State Text.Pandoc.Parsing.Future
    Text.Pandoc.Readers.Docx.Lists Text.Pandoc.Readers.Docx.Combine
    Text.Pandoc.Readers.Docx.Parse
    Text.Pandoc.Readers.Docx.Parse.Styles Text.Pandoc.Readers.Docx.Util
    Text.Pandoc.Readers.Docx.Fields Text.Pandoc.Readers.HTML.Parsing
    Text.Pandoc.Readers.HTML.Table
    Text.Pandoc.Readers.HTML.TagCategories
    Text.Pandoc.Readers.HTML.Types Text.Pandoc.Readers.LaTeX.Inline
    Text.Pandoc.Readers.LaTeX.Citation Text.Pandoc.Readers.LaTeX.Lang
    Text.Pandoc.Readers.LaTeX.Macro Text.Pandoc.Readers.LaTeX.Math
    Text.Pandoc.Readers.LaTeX.Parsing Text.Pandoc.Readers.LaTeX.SIunitx
    Text.Pandoc.Readers.LaTeX.Table Text.Pandoc.Readers.ODT.Base
    Text.Pandoc.Readers.ODT.Namespaces
    Text.Pandoc.Readers.ODT.StyleReader
    Text.Pandoc.Readers.ODT.ContentReader
    Text.Pandoc.Readers.ODT.Generic.Fallible
    Text.Pandoc.Readers.ODT.Generic.SetMap
    Text.Pandoc.Readers.ODT.Generic.Utils
    Text.Pandoc.Readers.ODT.Generic.Namespaces
    Text.Pandoc.Readers.ODT.Generic.XMLConverter
    Text.Pandoc.Readers.ODT.Arrows.State
    Text.Pandoc.Readers.ODT.Arrows.Utils
    Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
    Text.Pandoc.Readers.Org.DocumentTree
    Text.Pandoc.Readers.Org.ExportSettings
    Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
    Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
    Text.Pandoc.Readers.Org.Shared Text.Pandoc.Readers.Metadata
    Text.Pandoc.Readers.Roff Text.Pandoc.Writers.Docx.StyleMap
    Text.Pandoc.Writers.Docx.Table Text.Pandoc.Writers.Docx.Types
    Text.Pandoc.Writers.GridTable Text.Pandoc.Writers.JATS.References
    Text.Pandoc.Writers.JATS.Table Text.Pandoc.Writers.JATS.Types
    Text.Pandoc.Writers.LaTeX.Caption Text.Pandoc.Writers.LaTeX.Notes
    Text.Pandoc.Writers.LaTeX.Table Text.Pandoc.Writers.LaTeX.Lang
    Text.Pandoc.Writers.LaTeX.Types Text.Pandoc.Writers.LaTeX.Citation
    Text.Pandoc.Writers.LaTeX.Util Text.Pandoc.Writers.Markdown.Table
    Text.Pandoc.Writers.Markdown.Types
    Text.Pandoc.Writers.Markdown.Inline Text.Pandoc.Writers.Roff
    Text.Pandoc.Writers.Blaze
    Text.Pandoc.Writers.Powerpoint.Presentation
    Text.Pandoc.Writers.Powerpoint.Output Text.Pandoc.TeX
    Text.Pandoc.URI Text.Pandoc.CSS Text.Pandoc.CSV
    Text.Pandoc.RoffChar Text.Pandoc.UUID Text.Pandoc.Image
    Text.Pandoc.Citeproc.BibTeX Text.Pandoc.Citeproc.Name
    Text.Pandoc.Citeproc.CslJson Text.Pandoc.Citeproc.Data
    Text.Pandoc.Citeproc.Locator Text.Pandoc.Citeproc.MetaValue
    Text.Pandoc.Citeproc.Util Paths_pandoc

import-dirs:          /usr/lib/ghc-9.0.2/site-local/pandoc-3.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/pandoc-3.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pandoc
hs-libraries:         HSpandoc-3.1.2-AIgJLY68Ybw9Dp2bKMkgrF
depends:
    Glob-0.10.2-3nVoBiOJijA9OiBj5S4ual
    JuicyPixels-3.3.8-F8bHCdJrIIDDR6l4PKjzmn
    SHA-1.6.4.4-1UNVNO3JXJdDGqRoMkntZx
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    aeson-pretty-0.8.9-5lTV2yokao3rqi6vQJbJu array-0.5.4.0
    attoparsec-0.14.4-4fjJnHqpy2x7zsjAU0XRWO base-4.15.1.0
    base64-0.4.2.4-5gSrOpzXmeeDBfLMhZMNQx binary-0.8.8.0
    blaze-html-0.9.1.2-CjGwhvVZpiI2yqci6C0Ey8
    blaze-markup-0.8.2.8-6v8b9MTZTaSH16HPjvW1LE bytestring-0.10.12.1
    case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    citeproc-0.8.1-D7DidnHy97N6wBV0thcEpg
    commonmark-0.2.3-AQbP1GUPLsY6cdSOJIFWTI
    commonmark-extensions-0.2.3.5-4A82hvFZtXB1FgF80QejPj
    commonmark-pandoc-0.2.1.3-LxsO7bGhPc4nNv1Lh2hKP containers-0.6.4.1
    crypton-connection-0.3.1-DNCQqFhvIUdFJUu0ijgQzv
    data-default-0.7.1.1-8E5NGoO1gLxEpVTFDWBmYU deepseq-1.4.5.0
    directory-1.3.6.2 doclayout-0.4.0.1-GzkdJ3DlTkxAzMbIxH5s4M
    doctemplates-0.11-GjNv7OxcDEA19ZJhiJspqm
    emojis-0.1.2-HYiXDTkm1qCKHL8IMQ0Eoc exceptions-0.10.4
    file-embed-0.0.15.0-FF5xUPWKaB3GI64c6hgPnn filepath-1.4.2.1
    gridtables-0.1.0.0-7rhxXpvHb3w7ODYCXqfj8Q
    haddock-library-1.10.0-GWiZs4jdAbbKkJIRVZwGyN
    http-client-0.7.13.1-E99uRcHPg6l4pFHjAbr9ZZ
    http-client-tls-0.3.6.3-83gtNL69go4HzvcH7SqbBN
    http-types-0.12.3-GFhxs6XVQ6bETbOR4vEFmW
    ipynb-0.2-CH40S7WwsDA3Zune5exyhK
    jira-wiki-markup-1.5.1-Gm4UKjkBcGaHpd3wXbX2TZ
    mime-types-0.1.1.0-BzxJUblii5FKIF9eg8xWXx mtl-2.2.2
    network-3.1.4.0-5PP4MrJJnZZJkybIlRRAPq
    network-uri-2.6.4.2-18lVeOrHqdkDTTcK9hqBly
    pandoc-3.1.2-9VGLBxlt6wu6wNuuCBpqw-xml-light
    pandoc-types-1.23-8T5BFSbkNLg9H6oAOnuVjk parsec-3.1.14.0
    pretty-1.1.3.6 pretty-show-1.10-E9zv3yZn35Y9VpF8wkb8MR
    process-1.6.13.2 random-1.2.1.1-K0OGGZ2RgxUBJhcMzCddDt
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR
    skylighting-0.13.3-fGAYMkcWfSF2BL2NpibbL
    skylighting-core-0.13.3-I2KEjNI9KR4AiTF4sCod8m
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf
    syb-0.7.2.3-ItYotKJTU3VJfC5cskyLmn
    tagsoup-0.14.8-3tQ7ofi3FnhGN2GcUfc45Q
    temporary-1.3-Bh4fczMTiyN6QOEVSScDYk
    texmath-0.12.8-6OCaXhq3cf84zh5PWgN9fl text-1.2.5.0
    text-conversions-0.3.1.1-D8RMRiJvqrLIdvSJkbx75f time-1.9.3
    unicode-collation-0.1.3.5-CQ5ujj1HKW6cuPt8EjAae
    unicode-transforms-0.4.0.1-XPPFaCFiZ07DBwZBw9Iwe unix-2.7.2.2
    xml-1.3.14-6hlhhPBptprHwK7nsE7OzM
    yaml-0.11.11.2-HMJi93sq55j29LTuvNA0C1
    zip-archive-0.4.3-3F07V5YI0R8G40JcJ1U2BC
    zlib-0.6.3.0-5MlrrAbgjA8AXbUw8xgJze

haddock-interfaces:   /usr/share/doc/haskell-pandoc/html/pandoc.haddock
haddock-html:         /usr/share/doc/haskell-pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

