#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pgp-wordlist
version:              0.1.0.3
visibility:           public
id:                   pgp-wordlist-0.1.0.3-L1JjcsLQkw2EgUKoLnZYMc
key:                  pgp-wordlist-0.1.0.3-L1JjcsLQkw2EgUKoLnZYMc
license:              BSD-3-Clause
copyright:            David Luposchainsky <dluposchainsky(λ)gmail.com>
maintainer:           David Luposchainsky <dluposchainsky(λ)gmail.com>
author:               David Luposchainsky <dluposchainsky(λ)gmail.com>
homepage:             https://github.com/quchen/pgp-wordlist
synopsis:
    Translate between binary data and a human-readable
    collection of words.

description:
    Translate between binary data and a human-readable
    collection of words.

    The PGP Word List consists of two phonetic alphabets, each
    with one word per possible byte value. A string of bytes
    is translated with these alphabets, alternating between
    them at each byte.

    The PGP words corresponding to the bytes @5B 1D CA 6E@
    are "erase breakaway spellbind headwaters", for example.

    For further information, see
    <http://en.wikipedia.org/wiki/PGP_word_list Wikipedia>.

category:             Data, Serialization
abi:                  f494d7d256b5983c292fa281bb747046
exposed:              True
exposed-modules:
    Data.Text.PgpWordlist Data.Text.PgpWordlist.Internal.AltList
    Data.Text.PgpWordlist.Internal.Convert
    Data.Text.PgpWordlist.Internal.Types
    Data.Text.PgpWordlist.Internal.Word8Bimap
    Data.Text.PgpWordlist.Internal.Words

import-dirs:          /usr/lib/ghc-9.0.2/site-local/pgp-wordlist-0.1.0.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/pgp-wordlist-0.1.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pgp-wordlist
hs-libraries:         HSpgp-wordlist-0.1.0.3-L1JjcsLQkw2EgUKoLnZYMc
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1 text-1.2.5.0
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:
    /usr/share/doc/haskell-pgp-wordlist/html/pgp-wordlist.haddock

haddock-html:         /usr/share/doc/haskell-pgp-wordlist/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

